/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An API key credential provider for gateway authentication. This structure contains the configuration for
 * authenticating with the target endpoint using an API key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiKeyCredentialProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<ApiKeyCredentialProvider.Builder, ApiKeyCredentialProvider> {
    private static final SdkField<String> PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerArn").getter(getter(ApiKeyCredentialProvider::providerArn)).setter(setter(Builder::providerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerArn").build()).build();

    private static final SdkField<String> CREDENTIAL_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialParameterName").getter(getter(ApiKeyCredentialProvider::credentialParameterName))
            .setter(setter(Builder::credentialParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialParameterName").build())
            .build();

    private static final SdkField<String> CREDENTIAL_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialPrefix").getter(getter(ApiKeyCredentialProvider::credentialPrefix))
            .setter(setter(Builder::credentialPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialPrefix").build()).build();

    private static final SdkField<String> CREDENTIAL_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialLocation").getter(getter(ApiKeyCredentialProvider::credentialLocationAsString))
            .setter(setter(Builder::credentialLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_ARN_FIELD,
            CREDENTIAL_PARAMETER_NAME_FIELD, CREDENTIAL_PREFIX_FIELD, CREDENTIAL_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String providerArn;

    private final String credentialParameterName;

    private final String credentialPrefix;

    private final String credentialLocation;

    private ApiKeyCredentialProvider(BuilderImpl builder) {
        this.providerArn = builder.providerArn;
        this.credentialParameterName = builder.credentialParameterName;
        this.credentialPrefix = builder.credentialPrefix;
        this.credentialLocation = builder.credentialLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the API key credential provider. This ARN identifies the provider in Amazon Web
     * Services.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the API key credential provider. This ARN identifies the provider in
     *         Amazon Web Services.
     */
    public final String providerArn() {
        return providerArn;
    }

    /**
     * <p>
     * The name of the credential parameter for the API key. This parameter name is used when sending the API key to the
     * target endpoint.
     * </p>
     * 
     * @return The name of the credential parameter for the API key. This parameter name is used when sending the API
     *         key to the target endpoint.
     */
    public final String credentialParameterName() {
        return credentialParameterName;
    }

    /**
     * <p>
     * The prefix for the API key credential. This prefix is added to the API key when sending it to the target
     * endpoint.
     * </p>
     * 
     * @return The prefix for the API key credential. This prefix is added to the API key when sending it to the target
     *         endpoint.
     */
    public final String credentialPrefix() {
        return credentialPrefix;
    }

    /**
     * <p>
     * The location of the API key credential. This field specifies where in the request the API key should be placed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #credentialLocation} will return {@link ApiKeyCredentialLocation#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #credentialLocationAsString}.
     * </p>
     * 
     * @return The location of the API key credential. This field specifies where in the request the API key should be
     *         placed.
     * @see ApiKeyCredentialLocation
     */
    public final ApiKeyCredentialLocation credentialLocation() {
        return ApiKeyCredentialLocation.fromValue(credentialLocation);
    }

    /**
     * <p>
     * The location of the API key credential. This field specifies where in the request the API key should be placed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #credentialLocation} will return {@link ApiKeyCredentialLocation#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #credentialLocationAsString}.
     * </p>
     * 
     * @return The location of the API key credential. This field specifies where in the request the API key should be
     *         placed.
     * @see ApiKeyCredentialLocation
     */
    public final String credentialLocationAsString() {
        return credentialLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerArn());
        hashCode = 31 * hashCode + Objects.hashCode(credentialParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(credentialPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(credentialLocationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiKeyCredentialProvider)) {
            return false;
        }
        ApiKeyCredentialProvider other = (ApiKeyCredentialProvider) obj;
        return Objects.equals(providerArn(), other.providerArn())
                && Objects.equals(credentialParameterName(), other.credentialParameterName())
                && Objects.equals(credentialPrefix(), other.credentialPrefix())
                && Objects.equals(credentialLocationAsString(), other.credentialLocationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiKeyCredentialProvider").add("ProviderArn", providerArn())
                .add("CredentialParameterName", credentialParameterName()).add("CredentialPrefix", credentialPrefix())
                .add("CredentialLocation", credentialLocationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "providerArn":
            return Optional.ofNullable(clazz.cast(providerArn()));
        case "credentialParameterName":
            return Optional.ofNullable(clazz.cast(credentialParameterName()));
        case "credentialPrefix":
            return Optional.ofNullable(clazz.cast(credentialPrefix()));
        case "credentialLocation":
            return Optional.ofNullable(clazz.cast(credentialLocationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("providerArn", PROVIDER_ARN_FIELD);
        map.put("credentialParameterName", CREDENTIAL_PARAMETER_NAME_FIELD);
        map.put("credentialPrefix", CREDENTIAL_PREFIX_FIELD);
        map.put("credentialLocation", CREDENTIAL_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiKeyCredentialProvider, T> g) {
        return obj -> g.apply((ApiKeyCredentialProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiKeyCredentialProvider> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the API key credential provider. This ARN identifies the provider in Amazon
         * Web Services.
         * </p>
         * 
         * @param providerArn
         *        The Amazon Resource Name (ARN) of the API key credential provider. This ARN identifies the provider in
         *        Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerArn(String providerArn);

        /**
         * <p>
         * The name of the credential parameter for the API key. This parameter name is used when sending the API key to
         * the target endpoint.
         * </p>
         * 
         * @param credentialParameterName
         *        The name of the credential parameter for the API key. This parameter name is used when sending the API
         *        key to the target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialParameterName(String credentialParameterName);

        /**
         * <p>
         * The prefix for the API key credential. This prefix is added to the API key when sending it to the target
         * endpoint.
         * </p>
         * 
         * @param credentialPrefix
         *        The prefix for the API key credential. This prefix is added to the API key when sending it to the
         *        target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialPrefix(String credentialPrefix);

        /**
         * <p>
         * The location of the API key credential. This field specifies where in the request the API key should be
         * placed.
         * </p>
         * 
         * @param credentialLocation
         *        The location of the API key credential. This field specifies where in the request the API key should
         *        be placed.
         * @see ApiKeyCredentialLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiKeyCredentialLocation
         */
        Builder credentialLocation(String credentialLocation);

        /**
         * <p>
         * The location of the API key credential. This field specifies where in the request the API key should be
         * placed.
         * </p>
         * 
         * @param credentialLocation
         *        The location of the API key credential. This field specifies where in the request the API key should
         *        be placed.
         * @see ApiKeyCredentialLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiKeyCredentialLocation
         */
        Builder credentialLocation(ApiKeyCredentialLocation credentialLocation);
    }

    static final class BuilderImpl implements Builder {
        private String providerArn;

        private String credentialParameterName;

        private String credentialPrefix;

        private String credentialLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiKeyCredentialProvider model) {
            providerArn(model.providerArn);
            credentialParameterName(model.credentialParameterName);
            credentialPrefix(model.credentialPrefix);
            credentialLocation(model.credentialLocation);
        }

        public final String getProviderArn() {
            return providerArn;
        }

        public final void setProviderArn(String providerArn) {
            this.providerArn = providerArn;
        }

        @Override
        public final Builder providerArn(String providerArn) {
            this.providerArn = providerArn;
            return this;
        }

        public final String getCredentialParameterName() {
            return credentialParameterName;
        }

        public final void setCredentialParameterName(String credentialParameterName) {
            this.credentialParameterName = credentialParameterName;
        }

        @Override
        public final Builder credentialParameterName(String credentialParameterName) {
            this.credentialParameterName = credentialParameterName;
            return this;
        }

        public final String getCredentialPrefix() {
            return credentialPrefix;
        }

        public final void setCredentialPrefix(String credentialPrefix) {
            this.credentialPrefix = credentialPrefix;
        }

        @Override
        public final Builder credentialPrefix(String credentialPrefix) {
            this.credentialPrefix = credentialPrefix;
            return this;
        }

        public final String getCredentialLocation() {
            return credentialLocation;
        }

        public final void setCredentialLocation(String credentialLocation) {
            this.credentialLocation = credentialLocation;
        }

        @Override
        public final Builder credentialLocation(String credentialLocation) {
            this.credentialLocation = credentialLocation;
            return this;
        }

        @Override
        public final Builder credentialLocation(ApiKeyCredentialLocation credentialLocation) {
            this.credentialLocation(credentialLocation == null ? null : credentialLocation.toString());
            return this;
        }

        @Override
        public ApiKeyCredentialProvider build() {
            return new ApiKeyCredentialProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
