/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyStrategyConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NamespacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyMemoryStrategyInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModifyMemoryStrategyInput> {
    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryStrategyId").getter(ModifyMemoryStrategyInput.getter(ModifyMemoryStrategyInput::memoryStrategyId)).setter(ModifyMemoryStrategyInput.setter(Builder::memoryStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ModifyMemoryStrategyInput.getter(ModifyMemoryStrategyInput::description)).setter(ModifyMemoryStrategyInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespaces").getter(ModifyMemoryStrategyInput.getter(ModifyMemoryStrategyInput::namespaces)).setter(ModifyMemoryStrategyInput.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ModifyStrategyConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(ModifyMemoryStrategyInput.getter(ModifyMemoryStrategyInput::configuration)).setter(ModifyMemoryStrategyInput.setter(Builder::configuration)).constructor(ModifyStrategyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_STRATEGY_ID_FIELD, DESCRIPTION_FIELD, NAMESPACES_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyMemoryStrategyInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memoryStrategyId;
    private final String description;
    private final List<String> namespaces;
    private final ModifyStrategyConfiguration configuration;

    private ModifyMemoryStrategyInput(BuilderImpl builder) {
        this.memoryStrategyId = builder.memoryStrategyId;
        this.description = builder.description;
        this.namespaces = builder.namespaces;
        this.configuration = builder.configuration;
    }

    public final String memoryStrategyId() {
        return this.memoryStrategyId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public final List<String> namespaces() {
        return this.namespaces;
    }

    public final ModifyStrategyConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespaces() ? this.namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyMemoryStrategyInput)) {
            return false;
        }
        ModifyMemoryStrategyInput other = (ModifyMemoryStrategyInput)obj;
        return Objects.equals(this.memoryStrategyId(), other.memoryStrategyId()) && Objects.equals(this.description(), other.description()) && this.hasNamespaces() == other.hasNamespaces() && Objects.equals(this.namespaces(), other.namespaces()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyMemoryStrategyInput").add("MemoryStrategyId", (Object)this.memoryStrategyId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Namespaces", this.hasNamespaces() ? this.namespaces() : null).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryStrategyId": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategyId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyMemoryStrategyInput, T> g) {
        return obj -> g.apply((ModifyMemoryStrategyInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memoryStrategyId;
        private String description;
        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();
        private ModifyStrategyConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyMemoryStrategyInput model) {
            this.memoryStrategyId(model.memoryStrategyId);
            this.description(model.description);
            this.namespaces(model.namespaces);
            this.configuration(model.configuration);
        }

        public final String getMemoryStrategyId() {
            return this.memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (this.namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final ModifyStrategyConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ModifyStrategyConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ModifyStrategyConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ModifyMemoryStrategyInput build() {
            return new ModifyMemoryStrategyInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModifyMemoryStrategyInput> {
        public Builder memoryStrategyId(String var1);

        public Builder description(String var1);

        public Builder namespaces(Collection<String> var1);

        public Builder namespaces(String ... var1);

        public Builder configuration(ModifyStrategyConfiguration var1);

        default public Builder configuration(Consumer<ModifyStrategyConfiguration.Builder> configuration) {
            return this.configuration((ModifyStrategyConfiguration)((ModifyStrategyConfiguration.Builder)ModifyStrategyConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

