/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSummary;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse;

public class ListBrowsersPublisher
implements SdkPublisher<ListBrowsersResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListBrowsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBrowsersPublisher(BedrockAgentCoreControlAsyncClient client, ListBrowsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBrowsersPublisher(BedrockAgentCoreControlAsyncClient client, ListBrowsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBrowsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBrowsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BrowserSummary> browserSummaries() {
        Function<ListBrowsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.browserSummaries() != null) {
                return response.browserSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBrowsersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBrowsersResponseFetcher
    implements AsyncPageFetcher<ListBrowsersResponse> {
        private ListBrowsersResponseFetcher() {
        }

        public boolean hasNextPage(ListBrowsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBrowsersResponse> nextPage(ListBrowsersResponse previousPage) {
            if (previousPage == null) {
                return ListBrowsersPublisher.this.client.listBrowsers(ListBrowsersPublisher.this.firstRequest);
            }
            return ListBrowsersPublisher.this.client.listBrowsers((ListBrowsersRequest)((Object)ListBrowsersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

