/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.WorkloadIdentityDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAgentRuntimeResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, CreateAgentRuntimeResponse> {
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeArn").getter(CreateAgentRuntimeResponse.getter(CreateAgentRuntimeResponse::agentRuntimeArn)).setter(CreateAgentRuntimeResponse.setter(Builder::agentRuntimeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()}).build();
    private static final SdkField<WorkloadIdentityDetails> WORKLOAD_IDENTITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workloadIdentityDetails").getter(CreateAgentRuntimeResponse.getter(CreateAgentRuntimeResponse::workloadIdentityDetails)).setter(CreateAgentRuntimeResponse.setter(Builder::workloadIdentityDetails)).constructor(WorkloadIdentityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityDetails").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeId").getter(CreateAgentRuntimeResponse.getter(CreateAgentRuntimeResponse::agentRuntimeId)).setter(CreateAgentRuntimeResponse.setter(Builder::agentRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeId").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeVersion").getter(CreateAgentRuntimeResponse.getter(CreateAgentRuntimeResponse::agentRuntimeVersion)).setter(CreateAgentRuntimeResponse.setter(Builder::agentRuntimeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateAgentRuntimeResponse.getter(CreateAgentRuntimeResponse::createdAt)).setter(CreateAgentRuntimeResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateAgentRuntimeResponse.getter(CreateAgentRuntimeResponse::statusAsString)).setter(CreateAgentRuntimeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ARN_FIELD, WORKLOAD_IDENTITY_DETAILS_FIELD, AGENT_RUNTIME_ID_FIELD, AGENT_RUNTIME_VERSION_FIELD, CREATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAgentRuntimeResponse.memberNameToFieldInitializer();
    private final String agentRuntimeArn;
    private final WorkloadIdentityDetails workloadIdentityDetails;
    private final String agentRuntimeId;
    private final String agentRuntimeVersion;
    private final Instant createdAt;
    private final String status;

    private CreateAgentRuntimeResponse(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.workloadIdentityDetails = builder.workloadIdentityDetails;
        this.agentRuntimeId = builder.agentRuntimeId;
        this.agentRuntimeVersion = builder.agentRuntimeVersion;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
    }

    public final String agentRuntimeArn() {
        return this.agentRuntimeArn;
    }

    public final WorkloadIdentityDetails workloadIdentityDetails() {
        return this.workloadIdentityDetails;
    }

    public final String agentRuntimeId() {
        return this.agentRuntimeId;
    }

    public final String agentRuntimeVersion() {
        return this.agentRuntimeVersion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final AgentStatus status() {
        return AgentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadIdentityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRuntimeResponse)) {
            return false;
        }
        CreateAgentRuntimeResponse other = (CreateAgentRuntimeResponse)((Object)obj);
        return Objects.equals(this.agentRuntimeArn(), other.agentRuntimeArn()) && Objects.equals(this.workloadIdentityDetails(), other.workloadIdentityDetails()) && Objects.equals(this.agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(this.agentRuntimeVersion(), other.agentRuntimeVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAgentRuntimeResponse").add("AgentRuntimeArn", (Object)this.agentRuntimeArn()).add("WorkloadIdentityDetails", (Object)this.workloadIdentityDetails()).add("AgentRuntimeId", (Object)this.agentRuntimeId()).add("AgentRuntimeVersion", (Object)this.agentRuntimeVersion()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentRuntimeArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArn()));
            }
            case "workloadIdentityDetails": {
                return Optional.ofNullable(clazz.cast(this.workloadIdentityDetails()));
            }
            case "agentRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeId()));
            }
            case "agentRuntimeVersion": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeVersion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("workloadIdentityDetails", WORKLOAD_IDENTITY_DETAILS_FIELD);
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("agentRuntimeVersion", AGENT_RUNTIME_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRuntimeResponse, T> g) {
        return obj -> g.apply((CreateAgentRuntimeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String agentRuntimeArn;
        private WorkloadIdentityDetails workloadIdentityDetails;
        private String agentRuntimeId;
        private String agentRuntimeVersion;
        private Instant createdAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRuntimeResponse model) {
            super(model);
            this.agentRuntimeArn(model.agentRuntimeArn);
            this.workloadIdentityDetails(model.workloadIdentityDetails);
            this.agentRuntimeId(model.agentRuntimeId);
            this.agentRuntimeVersion(model.agentRuntimeVersion);
            this.createdAt(model.createdAt);
            this.status(model.status);
        }

        public final String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final WorkloadIdentityDetails.Builder getWorkloadIdentityDetails() {
            return this.workloadIdentityDetails != null ? this.workloadIdentityDetails.toBuilder() : null;
        }

        public final void setWorkloadIdentityDetails(WorkloadIdentityDetails.BuilderImpl workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails != null ? workloadIdentityDetails.build() : null;
        }

        @Override
        public final Builder workloadIdentityDetails(WorkloadIdentityDetails workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails;
            return this;
        }

        public final String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getAgentRuntimeVersion() {
            return this.agentRuntimeVersion;
        }

        public final void setAgentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
        }

        @Override
        public final Builder agentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateAgentRuntimeResponse build() {
            return new CreateAgentRuntimeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAgentRuntimeResponse> {
        public Builder agentRuntimeArn(String var1);

        public Builder workloadIdentityDetails(WorkloadIdentityDetails var1);

        default public Builder workloadIdentityDetails(Consumer<WorkloadIdentityDetails.Builder> workloadIdentityDetails) {
            return this.workloadIdentityDetails((WorkloadIdentityDetails)((WorkloadIdentityDetails.Builder)WorkloadIdentityDetails.builder().applyMutation(workloadIdentityDetails)).build());
        }

        public Builder agentRuntimeId(String var1);

        public Builder agentRuntimeVersion(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(AgentStatus var1);
    }
}

