/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSummary;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse;

public class ListBrowsersIterable
implements SdkIterable<ListBrowsersResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListBrowsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBrowsersIterable(BedrockAgentCoreControlClient client, ListBrowsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBrowsersResponseFetcher();
    }

    public Iterator<ListBrowsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BrowserSummary> browserSummaries() {
        Function<ListBrowsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.browserSummaries() != null) {
                return response.browserSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBrowsersResponseFetcher
    implements SyncPageFetcher<ListBrowsersResponse> {
        private ListBrowsersResponseFetcher() {
        }

        public boolean hasNextPage(ListBrowsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBrowsersResponse nextPage(ListBrowsersResponse previousPage) {
            if (previousPage == null) {
                return ListBrowsersIterable.this.client.listBrowsers(ListBrowsersIterable.this.firstRequest);
            }
            return ListBrowsersIterable.this.client.listBrowsers((ListBrowsersRequest)((Object)ListBrowsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

