/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a memory resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Memory implements SdkPojo, Serializable, ToCopyableBuilder<Memory.Builder, Memory> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Memory::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Memory::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Memory::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Memory::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKeyArn").getter(getter(Memory::encryptionKeyArn)).setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()).build();

    private static final SdkField<String> MEMORY_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryExecutionRoleArn").getter(getter(Memory::memoryExecutionRoleArn))
            .setter(setter(Builder::memoryExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryExecutionRoleArn").build())
            .build();

    private static final SdkField<Integer> EVENT_EXPIRY_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("eventExpiryDuration").getter(getter(Memory::eventExpiryDuration))
            .setter(setter(Builder::eventExpiryDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventExpiryDuration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Memory::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(Memory::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Memory::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Memory::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<List<MemoryStrategy>> STRATEGIES_FIELD = SdkField
            .<List<MemoryStrategy>> builder(MarshallingType.LIST)
            .memberName("strategies")
            .getter(getter(Memory::strategies))
            .setter(setter(Builder::strategies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemoryStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemoryStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ARN_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ENCRYPTION_KEY_ARN_FIELD,
                    MEMORY_EXECUTION_ROLE_ARN_FIELD, EVENT_EXPIRY_DURATION_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD,
                    CREATED_AT_FIELD, UPDATED_AT_FIELD, STRATEGIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final String description;

    private final String encryptionKeyArn;

    private final String memoryExecutionRoleArn;

    private final Integer eventExpiryDuration;

    private final String status;

    private final String failureReason;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final List<MemoryStrategy> strategies;

    private Memory(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.memoryExecutionRoleArn = builder.memoryExecutionRoleArn;
        this.eventExpiryDuration = builder.eventExpiryDuration;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.strategies = builder.strategies;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the memory.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the memory.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the memory.
     * </p>
     * 
     * @return The unique identifier of the memory.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the memory.
     * </p>
     * 
     * @return The name of the memory.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the memory.
     * </p>
     * 
     * @return The description of the memory.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the KMS key used to encrypt the memory.
     * </p>
     * 
     * @return The ARN of the KMS key used to encrypt the memory.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The ARN of the IAM role that provides permissions for the memory.
     * </p>
     * 
     * @return The ARN of the IAM role that provides permissions for the memory.
     */
    public final String memoryExecutionRoleArn() {
        return memoryExecutionRoleArn;
    }

    /**
     * <p>
     * The number of days after which memory events will expire.
     * </p>
     * 
     * @return The number of days after which memory events will expire.
     */
    public final Integer eventExpiryDuration() {
        return eventExpiryDuration;
    }

    /**
     * <p>
     * The current status of the memory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the memory.
     * @see MemoryStatus
     */
    public final MemoryStatus status() {
        return MemoryStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the memory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the memory.
     * @see MemoryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for failure if the memory is in a failed state.
     * </p>
     * 
     * @return The reason for failure if the memory is in a failed state.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The timestamp when the memory was created.
     * </p>
     * 
     * @return The timestamp when the memory was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the memory was last updated.
     * </p>
     * 
     * @return The timestamp when the memory was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Strategies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStrategies() {
        return strategies != null && !(strategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of memory strategies associated with this memory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStrategies} method.
     * </p>
     * 
     * @return The list of memory strategies associated with this memory.
     */
    public final List<MemoryStrategy> strategies() {
        return strategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(memoryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventExpiryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasStrategies() ? strategies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Memory)) {
            return false;
        }
        Memory other = (Memory) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(memoryExecutionRoleArn(), other.memoryExecutionRoleArn())
                && Objects.equals(eventExpiryDuration(), other.eventExpiryDuration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasStrategies() == other.hasStrategies()
                && Objects.equals(strategies(), other.strategies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Memory").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EncryptionKeyArn", encryptionKeyArn()).add("MemoryExecutionRoleArn", memoryExecutionRoleArn())
                .add("EventExpiryDuration", eventExpiryDuration()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("Strategies", hasStrategies() ? strategies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "encryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "memoryExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(memoryExecutionRoleArn()));
        case "eventExpiryDuration":
            return Optional.ofNullable(clazz.cast(eventExpiryDuration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "strategies":
            return Optional.ofNullable(clazz.cast(strategies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("memoryExecutionRoleArn", MEMORY_EXECUTION_ROLE_ARN_FIELD);
        map.put("eventExpiryDuration", EVENT_EXPIRY_DURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("strategies", STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Memory, T> g) {
        return obj -> g.apply((Memory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Memory> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the memory.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the memory.
         * </p>
         * 
         * @param id
         *        The unique identifier of the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the memory.
         * </p>
         * 
         * @param name
         *        The name of the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the memory.
         * </p>
         * 
         * @param description
         *        The description of the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the KMS key used to encrypt the memory.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The ARN of the KMS key used to encrypt the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The ARN of the IAM role that provides permissions for the memory.
         * </p>
         * 
         * @param memoryExecutionRoleArn
         *        The ARN of the IAM role that provides permissions for the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryExecutionRoleArn(String memoryExecutionRoleArn);

        /**
         * <p>
         * The number of days after which memory events will expire.
         * </p>
         * 
         * @param eventExpiryDuration
         *        The number of days after which memory events will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventExpiryDuration(Integer eventExpiryDuration);

        /**
         * <p>
         * The current status of the memory.
         * </p>
         * 
         * @param status
         *        The current status of the memory.
         * @see MemoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemoryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the memory.
         * </p>
         * 
         * @param status
         *        The current status of the memory.
         * @see MemoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemoryStatus
         */
        Builder status(MemoryStatus status);

        /**
         * <p>
         * The reason for failure if the memory is in a failed state.
         * </p>
         * 
         * @param failureReason
         *        The reason for failure if the memory is in a failed state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The timestamp when the memory was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the memory was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the memory was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the memory was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The list of memory strategies associated with this memory.
         * </p>
         * 
         * @param strategies
         *        The list of memory strategies associated with this memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strategies(Collection<MemoryStrategy> strategies);

        /**
         * <p>
         * The list of memory strategies associated with this memory.
         * </p>
         * 
         * @param strategies
         *        The list of memory strategies associated with this memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strategies(MemoryStrategy... strategies);

        /**
         * <p>
         * The list of memory strategies associated with this memory.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategy.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategy.Builder#build()} is
         * called immediately and its result is passed to {@link #strategies(List<MemoryStrategy>)}.
         * 
         * @param strategies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #strategies(java.util.Collection<MemoryStrategy>)
         */
        Builder strategies(Consumer<MemoryStrategy.Builder>... strategies);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String description;

        private String encryptionKeyArn;

        private String memoryExecutionRoleArn;

        private Integer eventExpiryDuration;

        private String status;

        private String failureReason;

        private Instant createdAt;

        private Instant updatedAt;

        private List<MemoryStrategy> strategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Memory model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            description(model.description);
            encryptionKeyArn(model.encryptionKeyArn);
            memoryExecutionRoleArn(model.memoryExecutionRoleArn);
            eventExpiryDuration(model.eventExpiryDuration);
            status(model.status);
            failureReason(model.failureReason);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            strategies(model.strategies);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getMemoryExecutionRoleArn() {
            return memoryExecutionRoleArn;
        }

        public final void setMemoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
        }

        @Override
        public final Builder memoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
            return this;
        }

        public final Integer getEventExpiryDuration() {
            return eventExpiryDuration;
        }

        public final void setEventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
        }

        @Override
        public final Builder eventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemoryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<MemoryStrategy.Builder> getStrategies() {
            List<MemoryStrategy.Builder> result = MemoryStrategyListCopier.copyToBuilder(this.strategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStrategies(Collection<MemoryStrategy.BuilderImpl> strategies) {
            this.strategies = MemoryStrategyListCopier.copyFromBuilder(strategies);
        }

        @Override
        public final Builder strategies(Collection<MemoryStrategy> strategies) {
            this.strategies = MemoryStrategyListCopier.copy(strategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strategies(MemoryStrategy... strategies) {
            strategies(Arrays.asList(strategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strategies(Consumer<MemoryStrategy.Builder>... strategies) {
            strategies(Stream.of(strategies).map(c -> MemoryStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Memory build() {
            return new Memory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
