/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input configuration for a custom OAuth2 provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomOauth2ProviderConfigInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomOauth2ProviderConfigInput.Builder, CustomOauth2ProviderConfigInput> {
    private static final SdkField<Oauth2Discovery> OAUTH_DISCOVERY_FIELD = SdkField
            .<Oauth2Discovery> builder(MarshallingType.SDK_POJO).memberName("oauthDiscovery")
            .getter(getter(CustomOauth2ProviderConfigInput::oauthDiscovery)).setter(setter(Builder::oauthDiscovery))
            .constructor(Oauth2Discovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthDiscovery").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(CustomOauth2ProviderConfigInput::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSecret").getter(getter(CustomOauth2ProviderConfigInput::clientSecret))
            .setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OAUTH_DISCOVERY_FIELD,
            CLIENT_ID_FIELD, CLIENT_SECRET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Oauth2Discovery oauthDiscovery;

    private final String clientId;

    private final String clientSecret;

    private CustomOauth2ProviderConfigInput(BuilderImpl builder) {
        this.oauthDiscovery = builder.oauthDiscovery;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
    }

    /**
     * <p>
     * The OAuth2 discovery information for the custom provider.
     * </p>
     * 
     * @return The OAuth2 discovery information for the custom provider.
     */
    public final Oauth2Discovery oauthDiscovery() {
        return oauthDiscovery;
    }

    /**
     * <p>
     * The client ID for the custom OAuth2 provider.
     * </p>
     * 
     * @return The client ID for the custom OAuth2 provider.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The client secret for the custom OAuth2 provider.
     * </p>
     * 
     * @return The client secret for the custom OAuth2 provider.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oauthDiscovery());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomOauth2ProviderConfigInput)) {
            return false;
        }
        CustomOauth2ProviderConfigInput other = (CustomOauth2ProviderConfigInput) obj;
        return Objects.equals(oauthDiscovery(), other.oauthDiscovery()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(clientSecret(), other.clientSecret());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomOauth2ProviderConfigInput").add("OauthDiscovery", oauthDiscovery())
                .add("ClientId", clientId())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oauthDiscovery":
            return Optional.ofNullable(clazz.cast(oauthDiscovery()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "clientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("oauthDiscovery", OAUTH_DISCOVERY_FIELD);
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("clientSecret", CLIENT_SECRET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomOauth2ProviderConfigInput, T> g) {
        return obj -> g.apply((CustomOauth2ProviderConfigInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomOauth2ProviderConfigInput> {
        /**
         * <p>
         * The OAuth2 discovery information for the custom provider.
         * </p>
         * 
         * @param oauthDiscovery
         *        The OAuth2 discovery information for the custom provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauthDiscovery(Oauth2Discovery oauthDiscovery);

        /**
         * <p>
         * The OAuth2 discovery information for the custom provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link Oauth2Discovery.Builder} avoiding the
         * need to create one manually via {@link Oauth2Discovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Oauth2Discovery.Builder#build()} is called immediately and its
         * result is passed to {@link #oauthDiscovery(Oauth2Discovery)}.
         * 
         * @param oauthDiscovery
         *        a consumer that will call methods on {@link Oauth2Discovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oauthDiscovery(Oauth2Discovery)
         */
        default Builder oauthDiscovery(Consumer<Oauth2Discovery.Builder> oauthDiscovery) {
            return oauthDiscovery(Oauth2Discovery.builder().applyMutation(oauthDiscovery).build());
        }

        /**
         * <p>
         * The client ID for the custom OAuth2 provider.
         * </p>
         * 
         * @param clientId
         *        The client ID for the custom OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The client secret for the custom OAuth2 provider.
         * </p>
         * 
         * @param clientSecret
         *        The client secret for the custom OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);
    }

    static final class BuilderImpl implements Builder {
        private Oauth2Discovery oauthDiscovery;

        private String clientId;

        private String clientSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomOauth2ProviderConfigInput model) {
            oauthDiscovery(model.oauthDiscovery);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
        }

        public final Oauth2Discovery.Builder getOauthDiscovery() {
            return oauthDiscovery != null ? oauthDiscovery.toBuilder() : null;
        }

        public final void setOauthDiscovery(Oauth2Discovery.BuilderImpl oauthDiscovery) {
            this.oauthDiscovery = oauthDiscovery != null ? oauthDiscovery.build() : null;
        }

        @Override
        public final Builder oauthDiscovery(Oauth2Discovery oauthDiscovery) {
            this.oauthDiscovery = oauthDiscovery;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Override
        public CustomOauth2ProviderConfigInput build() {
            return new CustomOauth2ProviderConfigInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
