/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for inbound JWT-based authorization, specifying how incoming requests should be authenticated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomJWTAuthorizerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomJWTAuthorizerConfiguration.Builder, CustomJWTAuthorizerConfiguration> {
    private static final SdkField<String> DISCOVERY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("discoveryUrl").getter(getter(CustomJWTAuthorizerConfiguration::discoveryUrl))
            .setter(setter(Builder::discoveryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryUrl").build()).build();

    private static final SdkField<List<String>> ALLOWED_AUDIENCE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAudience")
            .getter(getter(CustomJWTAuthorizerConfiguration::allowedAudience))
            .setter(setter(Builder::allowedAudience))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAudience").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_CLIENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedClients")
            .getter(getter(CustomJWTAuthorizerConfiguration::allowedClients))
            .setter(setter(Builder::allowedClients))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedClients").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_URL_FIELD,
            ALLOWED_AUDIENCE_FIELD, ALLOWED_CLIENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String discoveryUrl;

    private final List<String> allowedAudience;

    private final List<String> allowedClients;

    private CustomJWTAuthorizerConfiguration(BuilderImpl builder) {
        this.discoveryUrl = builder.discoveryUrl;
        this.allowedAudience = builder.allowedAudience;
        this.allowedClients = builder.allowedClients;
    }

    /**
     * <p>
     * This URL is used to fetch OpenID Connect configuration or authorization server metadata for validating incoming
     * tokens.
     * </p>
     * 
     * @return This URL is used to fetch OpenID Connect configuration or authorization server metadata for validating
     *         incoming tokens.
     */
    public final String discoveryUrl() {
        return discoveryUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAudience property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedAudience() {
        return allowedAudience != null && !(allowedAudience instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents individual audience values that are validated in the incoming JWT token validation process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAudience} method.
     * </p>
     * 
     * @return Represents individual audience values that are validated in the incoming JWT token validation process.
     */
    public final List<String> allowedAudience() {
        return allowedAudience;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedClients property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedClients() {
        return allowedClients != null && !(allowedClients instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents individual client IDs that are validated in the incoming JWT token validation process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedClients} method.
     * </p>
     * 
     * @return Represents individual client IDs that are validated in the incoming JWT token validation process.
     */
    public final List<String> allowedClients() {
        return allowedClients;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(discoveryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAudience() ? allowedAudience() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedClients() ? allowedClients() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomJWTAuthorizerConfiguration)) {
            return false;
        }
        CustomJWTAuthorizerConfiguration other = (CustomJWTAuthorizerConfiguration) obj;
        return Objects.equals(discoveryUrl(), other.discoveryUrl()) && hasAllowedAudience() == other.hasAllowedAudience()
                && Objects.equals(allowedAudience(), other.allowedAudience()) && hasAllowedClients() == other.hasAllowedClients()
                && Objects.equals(allowedClients(), other.allowedClients());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomJWTAuthorizerConfiguration").add("DiscoveryUrl", discoveryUrl())
                .add("AllowedAudience", hasAllowedAudience() ? allowedAudience() : null)
                .add("AllowedClients", hasAllowedClients() ? allowedClients() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "discoveryUrl":
            return Optional.ofNullable(clazz.cast(discoveryUrl()));
        case "allowedAudience":
            return Optional.ofNullable(clazz.cast(allowedAudience()));
        case "allowedClients":
            return Optional.ofNullable(clazz.cast(allowedClients()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("discoveryUrl", DISCOVERY_URL_FIELD);
        map.put("allowedAudience", ALLOWED_AUDIENCE_FIELD);
        map.put("allowedClients", ALLOWED_CLIENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomJWTAuthorizerConfiguration, T> g) {
        return obj -> g.apply((CustomJWTAuthorizerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomJWTAuthorizerConfiguration> {
        /**
         * <p>
         * This URL is used to fetch OpenID Connect configuration or authorization server metadata for validating
         * incoming tokens.
         * </p>
         * 
         * @param discoveryUrl
         *        This URL is used to fetch OpenID Connect configuration or authorization server metadata for validating
         *        incoming tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryUrl(String discoveryUrl);

        /**
         * <p>
         * Represents individual audience values that are validated in the incoming JWT token validation process.
         * </p>
         * 
         * @param allowedAudience
         *        Represents individual audience values that are validated in the incoming JWT token validation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAudience(Collection<String> allowedAudience);

        /**
         * <p>
         * Represents individual audience values that are validated in the incoming JWT token validation process.
         * </p>
         * 
         * @param allowedAudience
         *        Represents individual audience values that are validated in the incoming JWT token validation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAudience(String... allowedAudience);

        /**
         * <p>
         * Represents individual client IDs that are validated in the incoming JWT token validation process.
         * </p>
         * 
         * @param allowedClients
         *        Represents individual client IDs that are validated in the incoming JWT token validation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedClients(Collection<String> allowedClients);

        /**
         * <p>
         * Represents individual client IDs that are validated in the incoming JWT token validation process.
         * </p>
         * 
         * @param allowedClients
         *        Represents individual client IDs that are validated in the incoming JWT token validation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedClients(String... allowedClients);
    }

    static final class BuilderImpl implements Builder {
        private String discoveryUrl;

        private List<String> allowedAudience = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedClients = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomJWTAuthorizerConfiguration model) {
            discoveryUrl(model.discoveryUrl);
            allowedAudience(model.allowedAudience);
            allowedClients(model.allowedClients);
        }

        public final String getDiscoveryUrl() {
            return discoveryUrl;
        }

        public final void setDiscoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
        }

        @Override
        public final Builder discoveryUrl(String discoveryUrl) {
            this.discoveryUrl = discoveryUrl;
            return this;
        }

        public final Collection<String> getAllowedAudience() {
            if (allowedAudience instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAudience;
        }

        public final void setAllowedAudience(Collection<String> allowedAudience) {
            this.allowedAudience = AllowedAudienceListCopier.copy(allowedAudience);
        }

        @Override
        public final Builder allowedAudience(Collection<String> allowedAudience) {
            this.allowedAudience = AllowedAudienceListCopier.copy(allowedAudience);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAudience(String... allowedAudience) {
            allowedAudience(Arrays.asList(allowedAudience));
            return this;
        }

        public final Collection<String> getAllowedClients() {
            if (allowedClients instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedClients;
        }

        public final void setAllowedClients(Collection<String> allowedClients) {
            this.allowedClients = AllowedClientsListCopier.copy(allowedClients);
        }

        @Override
        public final Builder allowedClients(Collection<String> allowedClients) {
            this.allowedClients = AllowedClientsListCopier.copy(allowedClients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedClients(String... allowedClients) {
            allowedClients(Arrays.asList(allowedClients));
            return this;
        }

        @Override
        public CustomJWTAuthorizerConfiguration build() {
            return new CustomJWTAuthorizerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
