/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains consolidation configuration information for a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsolidationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsolidationConfiguration.Builder, ConsolidationConfiguration> {
    private static final SdkField<CustomConsolidationConfiguration> CUSTOM_CONSOLIDATION_CONFIGURATION_FIELD = SdkField
            .<CustomConsolidationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("customConsolidationConfiguration")
            .getter(getter(ConsolidationConfiguration::customConsolidationConfiguration))
            .setter(setter(Builder::customConsolidationConfiguration))
            .constructor(CustomConsolidationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customConsolidationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOM_CONSOLIDATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomConsolidationConfiguration customConsolidationConfiguration;

    private final Type type;

    private ConsolidationConfiguration(BuilderImpl builder) {
        this.customConsolidationConfiguration = builder.customConsolidationConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The custom consolidation configuration.
     * </p>
     * 
     * @return The custom consolidation configuration.
     */
    public final CustomConsolidationConfiguration customConsolidationConfiguration() {
        return customConsolidationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customConsolidationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidationConfiguration)) {
            return false;
        }
        ConsolidationConfiguration other = (ConsolidationConfiguration) obj;
        return Objects.equals(customConsolidationConfiguration(), other.customConsolidationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsolidationConfiguration")
                .add("CustomConsolidationConfiguration", customConsolidationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customConsolidationConfiguration":
            return Optional.ofNullable(clazz.cast(customConsolidationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customConsolidationConfiguration()} initialized to the given value.
     *
     * <p>
     * The custom consolidation configuration.
     * </p>
     * 
     * @param customConsolidationConfiguration
     *        The custom consolidation configuration.
     */
    public static ConsolidationConfiguration fromCustomConsolidationConfiguration(
            CustomConsolidationConfiguration customConsolidationConfiguration) {
        return builder().customConsolidationConfiguration(customConsolidationConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #customConsolidationConfiguration()} initialized to the given value.
     *
     * <p>
     * The custom consolidation configuration.
     * </p>
     * 
     * @param customConsolidationConfiguration
     *        The custom consolidation configuration.
     */
    public static ConsolidationConfiguration fromCustomConsolidationConfiguration(
            Consumer<CustomConsolidationConfiguration.Builder> customConsolidationConfiguration) {
        CustomConsolidationConfiguration.Builder builder = CustomConsolidationConfiguration.builder();
        customConsolidationConfiguration.accept(builder);
        return fromCustomConsolidationConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customConsolidationConfiguration", CUSTOM_CONSOLIDATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsolidationConfiguration, T> g) {
        return obj -> g.apply((ConsolidationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsolidationConfiguration> {
        /**
         * <p>
         * The custom consolidation configuration.
         * </p>
         * 
         * @param customConsolidationConfiguration
         *        The custom consolidation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customConsolidationConfiguration(CustomConsolidationConfiguration customConsolidationConfiguration);

        /**
         * <p>
         * The custom consolidation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomConsolidationConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomConsolidationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomConsolidationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customConsolidationConfiguration(CustomConsolidationConfiguration)}.
         * 
         * @param customConsolidationConfiguration
         *        a consumer that will call methods on {@link CustomConsolidationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customConsolidationConfiguration(CustomConsolidationConfiguration)
         */
        default Builder customConsolidationConfiguration(
                Consumer<CustomConsolidationConfiguration.Builder> customConsolidationConfiguration) {
            return customConsolidationConfiguration(CustomConsolidationConfiguration.builder()
                    .applyMutation(customConsolidationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomConsolidationConfiguration customConsolidationConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidationConfiguration model) {
            customConsolidationConfiguration(model.customConsolidationConfiguration);
        }

        public final CustomConsolidationConfiguration.Builder getCustomConsolidationConfiguration() {
            return customConsolidationConfiguration != null ? customConsolidationConfiguration.toBuilder() : null;
        }

        public final void setCustomConsolidationConfiguration(
                CustomConsolidationConfiguration.BuilderImpl customConsolidationConfiguration) {
            Object oldValue = this.customConsolidationConfiguration;
            this.customConsolidationConfiguration = customConsolidationConfiguration != null ? customConsolidationConfiguration
                    .build() : null;
            handleUnionValueChange(Type.CUSTOM_CONSOLIDATION_CONFIGURATION, oldValue, this.customConsolidationConfiguration);
        }

        @Override
        public final Builder customConsolidationConfiguration(CustomConsolidationConfiguration customConsolidationConfiguration) {
            Object oldValue = this.customConsolidationConfiguration;
            this.customConsolidationConfiguration = customConsolidationConfiguration;
            handleUnionValueChange(Type.CUSTOM_CONSOLIDATION_CONFIGURATION, oldValue, this.customConsolidationConfiguration);
            return this;
        }

        @Override
        public ConsolidationConfiguration build() {
            return new ConsolidationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConsolidationConfiguration#type()
     */
    public enum Type {
        CUSTOM_CONSOLIDATION_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
