/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgentRuntimeEndpointResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<CreateAgentRuntimeEndpointResponse.Builder, CreateAgentRuntimeEndpointResponse> {
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetVersion").getter(getter(CreateAgentRuntimeEndpointResponse::targetVersion))
            .setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersion").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeEndpointArn").getter(getter(CreateAgentRuntimeEndpointResponse::agentRuntimeEndpointArn))
            .setter(setter(Builder::agentRuntimeEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeEndpointArn").build())
            .build();

    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeArn").getter(getter(CreateAgentRuntimeEndpointResponse::agentRuntimeArn))
            .setter(setter(Builder::agentRuntimeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateAgentRuntimeEndpointResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreateAgentRuntimeEndpointResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VERSION_FIELD,
            AGENT_RUNTIME_ENDPOINT_ARN_FIELD, AGENT_RUNTIME_ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetVersion;

    private final String agentRuntimeEndpointArn;

    private final String agentRuntimeArn;

    private final String status;

    private final Instant createdAt;

    private CreateAgentRuntimeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.targetVersion = builder.targetVersion;
        this.agentRuntimeEndpointArn = builder.agentRuntimeEndpointArn;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The target version of the agent runtime for the endpoint.
     * </p>
     * 
     * @return The target version of the agent runtime for the endpoint.
     */
    public final String targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent runtime endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent runtime endpoint.
     */
    public final String agentRuntimeEndpointArn() {
        return agentRuntimeEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent runtime.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent runtime.
     */
    public final String agentRuntimeArn() {
        return agentRuntimeArn;
    }

    /**
     * <p>
     * The current status of the agent runtime endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime endpoint.
     * @see AgentEndpointStatus
     */
    public final AgentEndpointStatus status() {
        return AgentEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the agent runtime endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime endpoint.
     * @see AgentEndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the agent runtime endpoint was created.
     * </p>
     * 
     * @return The timestamp when the agent runtime endpoint was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRuntimeEndpointResponse)) {
            return false;
        }
        CreateAgentRuntimeEndpointResponse other = (CreateAgentRuntimeEndpointResponse) obj;
        return Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(agentRuntimeEndpointArn(), other.agentRuntimeEndpointArn())
                && Objects.equals(agentRuntimeArn(), other.agentRuntimeArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgentRuntimeEndpointResponse").add("TargetVersion", targetVersion())
                .add("AgentRuntimeEndpointArn", agentRuntimeEndpointArn()).add("AgentRuntimeArn", agentRuntimeArn())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "agentRuntimeEndpointArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeEndpointArn()));
        case "agentRuntimeArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetVersion", TARGET_VERSION_FIELD);
        map.put("agentRuntimeEndpointArn", AGENT_RUNTIME_ENDPOINT_ARN_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRuntimeEndpointResponse, T> g) {
        return obj -> g.apply((CreateAgentRuntimeEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAgentRuntimeEndpointResponse> {
        /**
         * <p>
         * The target version of the agent runtime for the endpoint.
         * </p>
         * 
         * @param targetVersion
         *        The target version of the agent runtime for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent runtime endpoint.
         * </p>
         * 
         * @param agentRuntimeEndpointArn
         *        The Amazon Resource Name (ARN) of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeArn
         *        The Amazon Resource Name (ARN) of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArn(String agentRuntimeArn);

        /**
         * <p>
         * The current status of the agent runtime endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime endpoint.
         * @see AgentEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the agent runtime endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime endpoint.
         * @see AgentEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentEndpointStatus
         */
        Builder status(AgentEndpointStatus status);

        /**
         * <p>
         * The timestamp when the agent runtime endpoint was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the agent runtime endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String targetVersion;

        private String agentRuntimeEndpointArn;

        private String agentRuntimeArn;

        private String status;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRuntimeEndpointResponse model) {
            super(model);
            targetVersion(model.targetVersion);
            agentRuntimeEndpointArn(model.agentRuntimeEndpointArn);
            agentRuntimeArn(model.agentRuntimeArn);
            status(model.status);
            createdAt(model.createdAt);
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final String getAgentRuntimeEndpointArn() {
            return agentRuntimeEndpointArn;
        }

        public final void setAgentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
        }

        @Override
        public final Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateAgentRuntimeEndpointResponse build() {
            return new CreateAgentRuntimeEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
