/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Agent;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse;

public class ListAgentRuntimeVersionsIterable
implements SdkIterable<ListAgentRuntimeVersionsResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListAgentRuntimeVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentRuntimeVersionsIterable(BedrockAgentCoreControlClient client, ListAgentRuntimeVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentRuntimeVersionsResponseFetcher();
    }

    public Iterator<ListAgentRuntimeVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Agent> agentRuntimes() {
        Function<ListAgentRuntimeVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentRuntimes() != null) {
                return response.agentRuntimes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentRuntimeVersionsResponseFetcher
    implements SyncPageFetcher<ListAgentRuntimeVersionsResponse> {
        private ListAgentRuntimeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentRuntimeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentRuntimeVersionsResponse nextPage(ListAgentRuntimeVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentRuntimeVersionsIterable.this.client.listAgentRuntimeVersions(ListAgentRuntimeVersionsIterable.this.firstRequest);
            }
            return ListAgentRuntimeVersionsIterable.this.client.listAgentRuntimeVersions((ListAgentRuntimeVersionsRequest)((Object)ListAgentRuntimeVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

