/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TargetSummary;

public class ListGatewayTargetsIterable
implements SdkIterable<ListGatewayTargetsResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListGatewayTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGatewayTargetsIterable(BedrockAgentCoreControlClient client, ListGatewayTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGatewayTargetsResponseFetcher();
    }

    public Iterator<ListGatewayTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TargetSummary> items() {
        Function<ListGatewayTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGatewayTargetsResponseFetcher
    implements SyncPageFetcher<ListGatewayTargetsResponse> {
        private ListGatewayTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewayTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGatewayTargetsResponse nextPage(ListGatewayTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListGatewayTargetsIterable.this.client.listGatewayTargets(ListGatewayTargetsIterable.this.firstRequest);
            }
            return ListGatewayTargetsIterable.this.client.listGatewayTargets((ListGatewayTargetsRequest)((Object)ListGatewayTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

