/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentEndpoint;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentEndpointsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAgentRuntimeEndpointsResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, ListAgentRuntimeEndpointsResponse> {
    private static final SdkField<List<AgentEndpoint>> RUNTIME_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("runtimeEndpoints").getter(ListAgentRuntimeEndpointsResponse.getter(ListAgentRuntimeEndpointsResponse::runtimeEndpoints)).setter(ListAgentRuntimeEndpointsResponse.setter(Builder::runtimeEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAgentRuntimeEndpointsResponse.getter(ListAgentRuntimeEndpointsResponse::nextToken)).setter(ListAgentRuntimeEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAgentRuntimeEndpointsResponse.memberNameToFieldInitializer();
    private final List<AgentEndpoint> runtimeEndpoints;
    private final String nextToken;

    private ListAgentRuntimeEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.runtimeEndpoints = builder.runtimeEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuntimeEndpoints() {
        return this.runtimeEndpoints != null && !(this.runtimeEndpoints instanceof SdkAutoConstructList);
    }

    public final List<AgentEndpoint> runtimeEndpoints() {
        return this.runtimeEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeEndpoints() ? this.runtimeEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentRuntimeEndpointsResponse)) {
            return false;
        }
        ListAgentRuntimeEndpointsResponse other = (ListAgentRuntimeEndpointsResponse)((Object)obj);
        return this.hasRuntimeEndpoints() == other.hasRuntimeEndpoints() && Objects.equals(this.runtimeEndpoints(), other.runtimeEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAgentRuntimeEndpointsResponse").add("RuntimeEndpoints", this.hasRuntimeEndpoints() ? this.runtimeEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runtimeEndpoints": {
                return Optional.ofNullable(clazz.cast(this.runtimeEndpoints()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("runtimeEndpoints", RUNTIME_ENDPOINTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAgentRuntimeEndpointsResponse, T> g) {
        return obj -> g.apply((ListAgentRuntimeEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private List<AgentEndpoint> runtimeEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentRuntimeEndpointsResponse model) {
            super(model);
            this.runtimeEndpoints(model.runtimeEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<AgentEndpoint.Builder> getRuntimeEndpoints() {
            List<AgentEndpoint.Builder> result = AgentEndpointsCopier.copyToBuilder(this.runtimeEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuntimeEndpoints(Collection<AgentEndpoint.BuilderImpl> runtimeEndpoints) {
            this.runtimeEndpoints = AgentEndpointsCopier.copyFromBuilder(runtimeEndpoints);
        }

        @Override
        public final Builder runtimeEndpoints(Collection<AgentEndpoint> runtimeEndpoints) {
            this.runtimeEndpoints = AgentEndpointsCopier.copy(runtimeEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeEndpoints(AgentEndpoint ... runtimeEndpoints) {
            this.runtimeEndpoints(Arrays.asList(runtimeEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeEndpoints(Consumer<AgentEndpoint.Builder> ... runtimeEndpoints) {
            this.runtimeEndpoints(Stream.of(runtimeEndpoints).map(c -> (AgentEndpoint)((AgentEndpoint.Builder)AgentEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentRuntimeEndpointsResponse build() {
            return new ListAgentRuntimeEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAgentRuntimeEndpointsResponse> {
        public Builder runtimeEndpoints(Collection<AgentEndpoint> var1);

        public Builder runtimeEndpoints(AgentEndpoint ... var1);

        public Builder runtimeEndpoints(Consumer<AgentEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

