/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiSchemaConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.McpLambdaTargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class McpTargetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, McpTargetConfiguration> {
    private static final SdkField<ApiSchemaConfiguration> OPEN_API_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openApiSchema").getter(McpTargetConfiguration.getter(McpTargetConfiguration::openApiSchema)).setter(McpTargetConfiguration.setter(Builder::openApiSchema)).constructor(ApiSchemaConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openApiSchema").build()}).build();
    private static final SdkField<ApiSchemaConfiguration> SMITHY_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("smithyModel").getter(McpTargetConfiguration.getter(McpTargetConfiguration::smithyModel)).setter(McpTargetConfiguration.setter(Builder::smithyModel)).constructor(ApiSchemaConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smithyModel").build()}).build();
    private static final SdkField<McpLambdaTargetConfiguration> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambda").getter(McpTargetConfiguration.getter(McpTargetConfiguration::lambda)).setter(McpTargetConfiguration.setter(Builder::lambda)).constructor(McpLambdaTargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_API_SCHEMA_FIELD, SMITHY_MODEL_FIELD, LAMBDA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = McpTargetConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ApiSchemaConfiguration openApiSchema;
    private final ApiSchemaConfiguration smithyModel;
    private final McpLambdaTargetConfiguration lambda;
    private final Type type;

    private McpTargetConfiguration(BuilderImpl builder) {
        this.openApiSchema = builder.openApiSchema;
        this.smithyModel = builder.smithyModel;
        this.lambda = builder.lambda;
        this.type = builder.type;
    }

    public final ApiSchemaConfiguration openApiSchema() {
        return this.openApiSchema;
    }

    public final ApiSchemaConfiguration smithyModel() {
        return this.smithyModel;
    }

    public final McpLambdaTargetConfiguration lambda() {
        return this.lambda;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.openApiSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.smithyModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof McpTargetConfiguration)) {
            return false;
        }
        McpTargetConfiguration other = (McpTargetConfiguration)obj;
        return Objects.equals(this.openApiSchema(), other.openApiSchema()) && Objects.equals(this.smithyModel(), other.smithyModel()) && Objects.equals(this.lambda(), other.lambda());
    }

    public final String toString() {
        return ToString.builder((String)"McpTargetConfiguration").add("OpenApiSchema", (Object)this.openApiSchema()).add("SmithyModel", (Object)this.smithyModel()).add("Lambda", (Object)this.lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "openApiSchema": {
                return Optional.ofNullable(clazz.cast(this.openApiSchema()));
            }
            case "smithyModel": {
                return Optional.ofNullable(clazz.cast(this.smithyModel()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
        }
        return Optional.empty();
    }

    public static McpTargetConfiguration fromOpenApiSchema(ApiSchemaConfiguration openApiSchema) {
        return (McpTargetConfiguration)McpTargetConfiguration.builder().openApiSchema(openApiSchema).build();
    }

    public static McpTargetConfiguration fromOpenApiSchema(Consumer<ApiSchemaConfiguration.Builder> openApiSchema) {
        ApiSchemaConfiguration.Builder builder = ApiSchemaConfiguration.builder();
        openApiSchema.accept(builder);
        return McpTargetConfiguration.fromOpenApiSchema((ApiSchemaConfiguration)builder.build());
    }

    public static McpTargetConfiguration fromSmithyModel(ApiSchemaConfiguration smithyModel) {
        return (McpTargetConfiguration)McpTargetConfiguration.builder().smithyModel(smithyModel).build();
    }

    public static McpTargetConfiguration fromSmithyModel(Consumer<ApiSchemaConfiguration.Builder> smithyModel) {
        ApiSchemaConfiguration.Builder builder = ApiSchemaConfiguration.builder();
        smithyModel.accept(builder);
        return McpTargetConfiguration.fromSmithyModel((ApiSchemaConfiguration)builder.build());
    }

    public static McpTargetConfiguration fromLambda(McpLambdaTargetConfiguration lambda) {
        return (McpTargetConfiguration)McpTargetConfiguration.builder().lambda(lambda).build();
    }

    public static McpTargetConfiguration fromLambda(Consumer<McpLambdaTargetConfiguration.Builder> lambda) {
        McpLambdaTargetConfiguration.Builder builder = McpLambdaTargetConfiguration.builder();
        lambda.accept(builder);
        return McpTargetConfiguration.fromLambda((McpLambdaTargetConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("openApiSchema", OPEN_API_SCHEMA_FIELD);
        map.put("smithyModel", SMITHY_MODEL_FIELD);
        map.put("lambda", LAMBDA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<McpTargetConfiguration, T> g) {
        return obj -> g.apply((McpTargetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        OPEN_API_SCHEMA,
        SMITHY_MODEL,
        LAMBDA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ApiSchemaConfiguration openApiSchema;
        private ApiSchemaConfiguration smithyModel;
        private McpLambdaTargetConfiguration lambda;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(McpTargetConfiguration model) {
            this.openApiSchema(model.openApiSchema);
            this.smithyModel(model.smithyModel);
            this.lambda(model.lambda);
        }

        public final ApiSchemaConfiguration.Builder getOpenApiSchema() {
            return this.openApiSchema != null ? this.openApiSchema.toBuilder() : null;
        }

        public final void setOpenApiSchema(ApiSchemaConfiguration.BuilderImpl openApiSchema) {
            ApiSchemaConfiguration oldValue = this.openApiSchema;
            this.openApiSchema = openApiSchema != null ? openApiSchema.build() : null;
            this.handleUnionValueChange(Type.OPEN_API_SCHEMA, oldValue, this.openApiSchema);
        }

        @Override
        public final Builder openApiSchema(ApiSchemaConfiguration openApiSchema) {
            ApiSchemaConfiguration oldValue = this.openApiSchema;
            this.openApiSchema = openApiSchema;
            this.handleUnionValueChange(Type.OPEN_API_SCHEMA, oldValue, this.openApiSchema);
            return this;
        }

        public final ApiSchemaConfiguration.Builder getSmithyModel() {
            return this.smithyModel != null ? this.smithyModel.toBuilder() : null;
        }

        public final void setSmithyModel(ApiSchemaConfiguration.BuilderImpl smithyModel) {
            ApiSchemaConfiguration oldValue = this.smithyModel;
            this.smithyModel = smithyModel != null ? smithyModel.build() : null;
            this.handleUnionValueChange(Type.SMITHY_MODEL, oldValue, this.smithyModel);
        }

        @Override
        public final Builder smithyModel(ApiSchemaConfiguration smithyModel) {
            ApiSchemaConfiguration oldValue = this.smithyModel;
            this.smithyModel = smithyModel;
            this.handleUnionValueChange(Type.SMITHY_MODEL, oldValue, this.smithyModel);
            return this;
        }

        public final McpLambdaTargetConfiguration.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        public final void setLambda(McpLambdaTargetConfiguration.BuilderImpl lambda) {
            McpLambdaTargetConfiguration oldValue = this.lambda;
            this.lambda = lambda != null ? lambda.build() : null;
            this.handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
        }

        @Override
        public final Builder lambda(McpLambdaTargetConfiguration lambda) {
            McpLambdaTargetConfiguration oldValue = this.lambda;
            this.lambda = lambda;
            this.handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
            return this;
        }

        public McpTargetConfiguration build() {
            return new McpTargetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, McpTargetConfiguration> {
        public Builder openApiSchema(ApiSchemaConfiguration var1);

        default public Builder openApiSchema(Consumer<ApiSchemaConfiguration.Builder> openApiSchema) {
            return this.openApiSchema((ApiSchemaConfiguration)((ApiSchemaConfiguration.Builder)ApiSchemaConfiguration.builder().applyMutation(openApiSchema)).build());
        }

        public Builder smithyModel(ApiSchemaConfiguration var1);

        default public Builder smithyModel(Consumer<ApiSchemaConfiguration.Builder> smithyModel) {
            return this.smithyModel((ApiSchemaConfiguration)((ApiSchemaConfiguration.Builder)ApiSchemaConfiguration.builder().applyMutation(smithyModel)).build());
        }

        public Builder lambda(McpLambdaTargetConfiguration var1);

        default public Builder lambda(Consumer<McpLambdaTargetConfiguration.Builder> lambda) {
            return this.lambda((McpLambdaTargetConfiguration)((McpLambdaTargetConfiguration.Builder)McpLambdaTargetConfiguration.builder().applyMutation(lambda)).build());
        }
    }
}

