/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Agent;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse;

public class ListAgentRuntimeVersionsPublisher
implements SdkPublisher<ListAgentRuntimeVersionsResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListAgentRuntimeVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentRuntimeVersionsPublisher(BedrockAgentCoreControlAsyncClient client, ListAgentRuntimeVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentRuntimeVersionsPublisher(BedrockAgentCoreControlAsyncClient client, ListAgentRuntimeVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentRuntimeVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentRuntimeVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Agent> agentRuntimes() {
        Function<ListAgentRuntimeVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentRuntimes() != null) {
                return response.agentRuntimes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentRuntimeVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentRuntimeVersionsResponseFetcher
    implements AsyncPageFetcher<ListAgentRuntimeVersionsResponse> {
        private ListAgentRuntimeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentRuntimeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentRuntimeVersionsResponse> nextPage(ListAgentRuntimeVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentRuntimeVersionsPublisher.this.client.listAgentRuntimeVersions(ListAgentRuntimeVersionsPublisher.this.firstRequest);
            }
            return ListAgentRuntimeVersionsPublisher.this.client.listAgentRuntimeVersions((ListAgentRuntimeVersionsRequest)((Object)ListAgentRuntimeVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

