/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentEndpointStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgentRuntimeEndpointResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, UpdateAgentRuntimeEndpointResponse> {
    private static final SdkField<String> LIVE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("liveVersion").getter(UpdateAgentRuntimeEndpointResponse.getter(UpdateAgentRuntimeEndpointResponse::liveVersion)).setter(UpdateAgentRuntimeEndpointResponse.setter(Builder::liveVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("liveVersion").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetVersion").getter(UpdateAgentRuntimeEndpointResponse.getter(UpdateAgentRuntimeEndpointResponse::targetVersion)).setter(UpdateAgentRuntimeEndpointResponse.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersion").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeEndpointArn").getter(UpdateAgentRuntimeEndpointResponse.getter(UpdateAgentRuntimeEndpointResponse::agentRuntimeEndpointArn)).setter(UpdateAgentRuntimeEndpointResponse.setter(Builder::agentRuntimeEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeEndpointArn").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeArn").getter(UpdateAgentRuntimeEndpointResponse.getter(UpdateAgentRuntimeEndpointResponse::agentRuntimeArn)).setter(UpdateAgentRuntimeEndpointResponse.setter(Builder::agentRuntimeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateAgentRuntimeEndpointResponse.getter(UpdateAgentRuntimeEndpointResponse::statusAsString)).setter(UpdateAgentRuntimeEndpointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdateAgentRuntimeEndpointResponse.getter(UpdateAgentRuntimeEndpointResponse::createdAt)).setter(UpdateAgentRuntimeEndpointResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(UpdateAgentRuntimeEndpointResponse.getter(UpdateAgentRuntimeEndpointResponse::lastUpdatedAt)).setter(UpdateAgentRuntimeEndpointResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIVE_VERSION_FIELD, TARGET_VERSION_FIELD, AGENT_RUNTIME_ENDPOINT_ARN_FIELD, AGENT_RUNTIME_ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAgentRuntimeEndpointResponse.memberNameToFieldInitializer();
    private final String liveVersion;
    private final String targetVersion;
    private final String agentRuntimeEndpointArn;
    private final String agentRuntimeArn;
    private final String status;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private UpdateAgentRuntimeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.liveVersion = builder.liveVersion;
        this.targetVersion = builder.targetVersion;
        this.agentRuntimeEndpointArn = builder.agentRuntimeEndpointArn;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String liveVersion() {
        return this.liveVersion;
    }

    public final String targetVersion() {
        return this.targetVersion;
    }

    public final String agentRuntimeEndpointArn() {
        return this.agentRuntimeEndpointArn;
    }

    public final String agentRuntimeArn() {
        return this.agentRuntimeArn;
    }

    public final AgentEndpointStatus status() {
        return AgentEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.liveVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentRuntimeEndpointResponse)) {
            return false;
        }
        UpdateAgentRuntimeEndpointResponse other = (UpdateAgentRuntimeEndpointResponse)((Object)obj);
        return Objects.equals(this.liveVersion(), other.liveVersion()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.agentRuntimeEndpointArn(), other.agentRuntimeEndpointArn()) && Objects.equals(this.agentRuntimeArn(), other.agentRuntimeArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgentRuntimeEndpointResponse").add("LiveVersion", (Object)this.liveVersion()).add("TargetVersion", (Object)this.targetVersion()).add("AgentRuntimeEndpointArn", (Object)this.agentRuntimeEndpointArn()).add("AgentRuntimeArn", (Object)this.agentRuntimeArn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "liveVersion": {
                return Optional.ofNullable(clazz.cast(this.liveVersion()));
            }
            case "targetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "agentRuntimeEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeEndpointArn()));
            }
            case "agentRuntimeArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("liveVersion", LIVE_VERSION_FIELD);
        map.put("targetVersion", TARGET_VERSION_FIELD);
        map.put("agentRuntimeEndpointArn", AGENT_RUNTIME_ENDPOINT_ARN_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentRuntimeEndpointResponse, T> g) {
        return obj -> g.apply((UpdateAgentRuntimeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String liveVersion;
        private String targetVersion;
        private String agentRuntimeEndpointArn;
        private String agentRuntimeArn;
        private String status;
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentRuntimeEndpointResponse model) {
            super(model);
            this.liveVersion(model.liveVersion);
            this.targetVersion(model.targetVersion);
            this.agentRuntimeEndpointArn(model.agentRuntimeEndpointArn);
            this.agentRuntimeArn(model.agentRuntimeArn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getLiveVersion() {
            return this.liveVersion;
        }

        public final void setLiveVersion(String liveVersion) {
            this.liveVersion = liveVersion;
        }

        @Override
        public final Builder liveVersion(String liveVersion) {
            this.liveVersion = liveVersion;
            return this;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final String getAgentRuntimeEndpointArn() {
            return this.agentRuntimeEndpointArn;
        }

        public final void setAgentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
        }

        @Override
        public final Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public UpdateAgentRuntimeEndpointResponse build() {
            return new UpdateAgentRuntimeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgentRuntimeEndpointResponse> {
        public Builder liveVersion(String var1);

        public Builder targetVersion(String var1);

        public Builder agentRuntimeEndpointArn(String var1);

        public Builder agentRuntimeArn(String var1);

        public Builder status(String var1);

        public Builder status(AgentEndpointStatus var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

