/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.S3Configuration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ToolDefinition;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ToolDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolSchema> {
    private static final SdkField<S3Configuration> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(ToolSchema.getter(ToolSchema::s3)).setter(ToolSchema.setter(Builder::s3)).constructor(S3Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final SdkField<List<ToolDefinition>> INLINE_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inlinePayload").getter(ToolSchema.getter(ToolSchema::inlinePayload)).setter(ToolSchema.setter(Builder::inlinePayload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlinePayload").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToolDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, INLINE_PAYLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolSchema.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Configuration s3;
    private final List<ToolDefinition> inlinePayload;
    private final Type type;

    private ToolSchema(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.inlinePayload = builder.inlinePayload;
        this.type = builder.type;
    }

    public final S3Configuration s3() {
        return this.s3;
    }

    public final boolean hasInlinePayload() {
        return this.inlinePayload != null && !(this.inlinePayload instanceof SdkAutoConstructList);
    }

    public final List<ToolDefinition> inlinePayload() {
        return this.inlinePayload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInlinePayload() ? this.inlinePayload() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolSchema)) {
            return false;
        }
        ToolSchema other = (ToolSchema)obj;
        return Objects.equals(this.s3(), other.s3()) && this.hasInlinePayload() == other.hasInlinePayload() && Objects.equals(this.inlinePayload(), other.inlinePayload());
    }

    public final String toString() {
        return ToString.builder((String)"ToolSchema").add("S3", (Object)this.s3()).add("InlinePayload", this.hasInlinePayload() ? this.inlinePayload() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "inlinePayload": {
                return Optional.ofNullable(clazz.cast(this.inlinePayload()));
            }
        }
        return Optional.empty();
    }

    public static ToolSchema fromS3(S3Configuration s3) {
        return (ToolSchema)ToolSchema.builder().s3(s3).build();
    }

    public static ToolSchema fromS3(Consumer<S3Configuration.Builder> s3) {
        S3Configuration.Builder builder = S3Configuration.builder();
        s3.accept(builder);
        return ToolSchema.fromS3((S3Configuration)builder.build());
    }

    public static ToolSchema fromInlinePayload(List<ToolDefinition> inlinePayload) {
        return (ToolSchema)ToolSchema.builder().inlinePayload(inlinePayload).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3", S3_FIELD);
        map.put("inlinePayload", INLINE_PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolSchema, T> g) {
        return obj -> g.apply((ToolSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3,
        INLINE_PAYLOAD,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3Configuration s3;
        private List<ToolDefinition> inlinePayload = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ToolSchema model) {
            this.s3(model.s3);
            this.inlinePayload(model.inlinePayload);
        }

        public final S3Configuration.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3Configuration.BuilderImpl s3) {
            S3Configuration oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3Configuration s3) {
            S3Configuration oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public final List<ToolDefinition.Builder> getInlinePayload() {
            List<ToolDefinition.Builder> result = ToolDefinitionsCopier.copyToBuilder(this.inlinePayload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlinePayload(Collection<ToolDefinition.BuilderImpl> inlinePayload) {
            List<ToolDefinition> oldValue = this.inlinePayload;
            this.inlinePayload = ToolDefinitionsCopier.copyFromBuilder(inlinePayload);
            this.handleUnionValueChange(Type.INLINE_PAYLOAD, oldValue, this.inlinePayload);
        }

        @Override
        public final Builder inlinePayload(Collection<ToolDefinition> inlinePayload) {
            List<ToolDefinition> oldValue = this.inlinePayload;
            this.inlinePayload = ToolDefinitionsCopier.copy(inlinePayload);
            this.handleUnionValueChange(Type.INLINE_PAYLOAD, oldValue, this.inlinePayload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlinePayload(ToolDefinition ... inlinePayload) {
            this.inlinePayload(Arrays.asList(inlinePayload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlinePayload(Consumer<ToolDefinition.Builder> ... inlinePayload) {
            this.inlinePayload(Stream.of(inlinePayload).map(c -> (ToolDefinition)((ToolDefinition.Builder)ToolDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ToolSchema build() {
            return new ToolSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolSchema> {
        public Builder s3(S3Configuration var1);

        default public Builder s3(Consumer<S3Configuration.Builder> s3) {
            return this.s3((S3Configuration)((S3Configuration.Builder)S3Configuration.builder().applyMutation(s3)).build());
        }

        public Builder inlinePayload(Collection<ToolDefinition> var1);

        public Builder inlinePayload(ToolDefinition ... var1);

        public Builder inlinePayload(Consumer<ToolDefinition.Builder> ... var1);
    }
}

