/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.WorkloadIdentityType;

public class ListWorkloadIdentitiesPublisher
implements SdkPublisher<ListWorkloadIdentitiesResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListWorkloadIdentitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkloadIdentitiesPublisher(BedrockAgentCoreControlAsyncClient client, ListWorkloadIdentitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkloadIdentitiesPublisher(BedrockAgentCoreControlAsyncClient client, ListWorkloadIdentitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkloadIdentitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkloadIdentitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkloadIdentityType> workloadIdentities() {
        Function<ListWorkloadIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workloadIdentities() != null) {
                return response.workloadIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkloadIdentitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkloadIdentitiesResponseFetcher
    implements AsyncPageFetcher<ListWorkloadIdentitiesResponse> {
        private ListWorkloadIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkloadIdentitiesResponse> nextPage(ListWorkloadIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadIdentitiesPublisher.this.client.listWorkloadIdentities(ListWorkloadIdentitiesPublisher.this.firstRequest);
            }
            return ListWorkloadIdentitiesPublisher.this.client.listWorkloadIdentities((ListWorkloadIdentitiesRequest)((Object)ListWorkloadIdentitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

