/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Oauth2CredentialProviderItem;

public class ListOauth2CredentialProvidersIterable
implements SdkIterable<ListOauth2CredentialProvidersResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListOauth2CredentialProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOauth2CredentialProvidersIterable(BedrockAgentCoreControlClient client, ListOauth2CredentialProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOauth2CredentialProvidersResponseFetcher();
    }

    public Iterator<ListOauth2CredentialProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Oauth2CredentialProviderItem> credentialProviders() {
        Function<ListOauth2CredentialProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.credentialProviders() != null) {
                return response.credentialProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOauth2CredentialProvidersResponseFetcher
    implements SyncPageFetcher<ListOauth2CredentialProvidersResponse> {
        private ListOauth2CredentialProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListOauth2CredentialProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOauth2CredentialProvidersResponse nextPage(ListOauth2CredentialProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListOauth2CredentialProvidersIterable.this.client.listOauth2CredentialProviders(ListOauth2CredentialProvidersIterable.this.firstRequest);
            }
            return ListOauth2CredentialProvidersIterable.this.client.listOauth2CredentialProviders((ListOauth2CredentialProvidersRequest)((Object)ListOauth2CredentialProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

