/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCodeInterpreterSessionRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, StartCodeInterpreterSessionRequest> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(StartCodeInterpreterSessionRequest.getter(StartCodeInterpreterSessionRequest::traceId)).setter(StartCodeInterpreterSessionRequest.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Trace-Id").build()}).build();
    private static final SdkField<String> TRACE_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceParent").getter(StartCodeInterpreterSessionRequest.getter(StartCodeInterpreterSessionRequest::traceParent)).setter(StartCodeInterpreterSessionRequest.setter(Builder::traceParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("traceparent").build()}).build();
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeInterpreterIdentifier").getter(StartCodeInterpreterSessionRequest.getter(StartCodeInterpreterSessionRequest::codeInterpreterIdentifier)).setter(StartCodeInterpreterSessionRequest.setter(Builder::codeInterpreterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("codeInterpreterIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartCodeInterpreterSessionRequest.getter(StartCodeInterpreterSessionRequest::name)).setter(StartCodeInterpreterSessionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sessionTimeoutSeconds").getter(StartCodeInterpreterSessionRequest.getter(StartCodeInterpreterSessionRequest::sessionTimeoutSeconds)).setter(StartCodeInterpreterSessionRequest.setter(Builder::sessionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeoutSeconds").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartCodeInterpreterSessionRequest.getter(StartCodeInterpreterSessionRequest::clientToken)).setter(StartCodeInterpreterSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD, TRACE_PARENT_FIELD, CODE_INTERPRETER_IDENTIFIER_FIELD, NAME_FIELD, SESSION_TIMEOUT_SECONDS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCodeInterpreterSessionRequest.memberNameToFieldInitializer();
    private final String traceId;
    private final String traceParent;
    private final String codeInterpreterIdentifier;
    private final String name;
    private final Integer sessionTimeoutSeconds;
    private final String clientToken;

    private StartCodeInterpreterSessionRequest(BuilderImpl builder) {
        super(builder);
        this.traceId = builder.traceId;
        this.traceParent = builder.traceParent;
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.name = builder.name;
        this.sessionTimeoutSeconds = builder.sessionTimeoutSeconds;
        this.clientToken = builder.clientToken;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final String traceParent() {
        return this.traceParent;
    }

    public final String codeInterpreterIdentifier() {
        return this.codeInterpreterIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final Integer sessionTimeoutSeconds() {
        return this.sessionTimeoutSeconds;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCodeInterpreterSessionRequest)) {
            return false;
        }
        StartCodeInterpreterSessionRequest other = (StartCodeInterpreterSessionRequest)((Object)obj);
        return Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.traceParent(), other.traceParent()) && Objects.equals(this.codeInterpreterIdentifier(), other.codeInterpreterIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sessionTimeoutSeconds(), other.sessionTimeoutSeconds()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartCodeInterpreterSessionRequest").add("TraceId", (Object)this.traceId()).add("TraceParent", (Object)this.traceParent()).add("CodeInterpreterIdentifier", (Object)this.codeInterpreterIdentifier()).add("Name", (Object)this.name()).add("SessionTimeoutSeconds", (Object)this.sessionTimeoutSeconds()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "traceParent": {
                return Optional.ofNullable(clazz.cast(this.traceParent()));
            }
            case "codeInterpreterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "sessionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeoutSeconds()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("X-Amzn-Trace-Id", TRACE_ID_FIELD);
        map.put("traceparent", TRACE_PARENT_FIELD);
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sessionTimeoutSeconds", SESSION_TIMEOUT_SECONDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCodeInterpreterSessionRequest, T> g) {
        return obj -> g.apply((StartCodeInterpreterSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String traceId;
        private String traceParent;
        private String codeInterpreterIdentifier;
        private String name;
        private Integer sessionTimeoutSeconds;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCodeInterpreterSessionRequest model) {
            super(model);
            this.traceId(model.traceId);
            this.traceParent(model.traceParent);
            this.codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            this.name(model.name);
            this.sessionTimeoutSeconds(model.sessionTimeoutSeconds);
            this.clientToken(model.clientToken);
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getTraceParent() {
            return this.traceParent;
        }

        public final void setTraceParent(String traceParent) {
            this.traceParent = traceParent;
        }

        @Override
        public final Builder traceParent(String traceParent) {
            this.traceParent = traceParent;
            return this;
        }

        public final String getCodeInterpreterIdentifier() {
            return this.codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getSessionTimeoutSeconds() {
            return this.sessionTimeoutSeconds;
        }

        public final void setSessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
        }

        @Override
        public final Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCodeInterpreterSessionRequest build() {
            return new StartCodeInterpreterSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCodeInterpreterSessionRequest> {
        public Builder traceId(String var1);

        public Builder traceParent(String var1);

        public Builder codeInterpreterIdentifier(String var1);

        public Builder name(String var1);

        public Builder sessionTimeoutSeconds(Integer var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

