/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryContent;
import software.amazon.awssdk.services.bedrockagentcore.model.MetadataMapCopier;
import software.amazon.awssdk.services.bedrockagentcore.model.MetadataValue;
import software.amazon.awssdk.services.bedrockagentcore.model.NamespacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemoryRecordSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemoryRecordSummary> {
    private static final SdkField<String> MEMORY_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryRecordId").getter(MemoryRecordSummary.getter(MemoryRecordSummary::memoryRecordId)).setter(MemoryRecordSummary.setter(Builder::memoryRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryRecordId").build()}).build();
    private static final SdkField<MemoryContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(MemoryRecordSummary.getter(MemoryRecordSummary::content)).setter(MemoryRecordSummary.setter(Builder::content)).constructor(MemoryContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryStrategyId").getter(MemoryRecordSummary.getter(MemoryRecordSummary::memoryStrategyId)).setter(MemoryRecordSummary.setter(Builder::memoryStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()}).build();
    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespaces").getter(MemoryRecordSummary.getter(MemoryRecordSummary::namespaces)).setter(MemoryRecordSummary.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(MemoryRecordSummary.getter(MemoryRecordSummary::createdAt)).setter(MemoryRecordSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("score").getter(MemoryRecordSummary.getter(MemoryRecordSummary::score)).setter(MemoryRecordSummary.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()}).build();
    private static final SdkField<Map<String, MetadataValue>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(MemoryRecordSummary.getter(MemoryRecordSummary::metadata)).setter(MemoryRecordSummary.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_RECORD_ID_FIELD, CONTENT_FIELD, MEMORY_STRATEGY_ID_FIELD, NAMESPACES_FIELD, CREATED_AT_FIELD, SCORE_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemoryRecordSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memoryRecordId;
    private final MemoryContent content;
    private final String memoryStrategyId;
    private final List<String> namespaces;
    private final Instant createdAt;
    private final Double score;
    private final Map<String, MetadataValue> metadata;

    private MemoryRecordSummary(BuilderImpl builder) {
        this.memoryRecordId = builder.memoryRecordId;
        this.content = builder.content;
        this.memoryStrategyId = builder.memoryStrategyId;
        this.namespaces = builder.namespaces;
        this.createdAt = builder.createdAt;
        this.score = builder.score;
        this.metadata = builder.metadata;
    }

    public final String memoryRecordId() {
        return this.memoryRecordId;
    }

    public final MemoryContent content() {
        return this.content;
    }

    public final String memoryStrategyId() {
        return this.memoryStrategyId;
    }

    public final boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public final List<String> namespaces() {
        return this.namespaces;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Double score() {
        return this.score;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, MetadataValue> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespaces() ? this.namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryRecordSummary)) {
            return false;
        }
        MemoryRecordSummary other = (MemoryRecordSummary)obj;
        return Objects.equals(this.memoryRecordId(), other.memoryRecordId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.memoryStrategyId(), other.memoryStrategyId()) && this.hasNamespaces() == other.hasNamespaces() && Objects.equals(this.namespaces(), other.namespaces()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.score(), other.score()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"MemoryRecordSummary").add("MemoryRecordId", (Object)this.memoryRecordId()).add("Content", (Object)this.content()).add("MemoryStrategyId", (Object)this.memoryStrategyId()).add("Namespaces", this.hasNamespaces() ? this.namespaces() : null).add("CreatedAt", (Object)this.createdAt()).add("Score", (Object)this.score()).add("Metadata", this.hasMetadata() ? this.metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryRecordId": {
                return Optional.ofNullable(clazz.cast(this.memoryRecordId()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "memoryStrategyId": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategyId()));
            }
            case "namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryRecordId", MEMORY_RECORD_ID_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("score", SCORE_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryRecordSummary, T> g) {
        return obj -> g.apply((MemoryRecordSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memoryRecordId;
        private MemoryContent content;
        private String memoryStrategyId;
        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Double score;
        private Map<String, MetadataValue> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryRecordSummary model) {
            this.memoryRecordId(model.memoryRecordId);
            this.content(model.content);
            this.memoryStrategyId(model.memoryStrategyId);
            this.namespaces(model.namespaces);
            this.createdAt(model.createdAt);
            this.score(model.score);
            this.metadata(model.metadata);
        }

        public final String getMemoryRecordId() {
            return this.memoryRecordId;
        }

        public final void setMemoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
        }

        @Override
        public final Builder memoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
            return this;
        }

        public final MemoryContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(MemoryContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MemoryContent content) {
            this.content = content;
            return this;
        }

        public final String getMemoryStrategyId() {
            return this.memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (this.namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final Map<String, MetadataValue.Builder> getMetadata() {
            Map<String, MetadataValue.Builder> result = MetadataMapCopier.copyToBuilder(this.metadata);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetadata(Map<String, MetadataValue.BuilderImpl> metadata) {
            this.metadata = MetadataMapCopier.copyFromBuilder(metadata);
        }

        @Override
        public final Builder metadata(Map<String, MetadataValue> metadata) {
            this.metadata = MetadataMapCopier.copy(metadata);
            return this;
        }

        public MemoryRecordSummary build() {
            return new MemoryRecordSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemoryRecordSummary> {
        public Builder memoryRecordId(String var1);

        public Builder content(MemoryContent var1);

        default public Builder content(Consumer<MemoryContent.Builder> content) {
            return this.content((MemoryContent)((MemoryContent.Builder)MemoryContent.builder().applyMutation(content)).build());
        }

        public Builder memoryStrategyId(String var1);

        public Builder namespaces(Collection<String> var1);

        public Builder namespaces(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder score(Double var1);

        public Builder metadata(Map<String, MetadataValue> var1);
    }
}

