/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.UserIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteResourceTokenAuthRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, CompleteResourceTokenAuthRequest> {
    private static final SdkField<UserIdentifier> USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userIdentifier").getter(CompleteResourceTokenAuthRequest.getter(CompleteResourceTokenAuthRequest::userIdentifier)).setter(CompleteResourceTokenAuthRequest.setter(Builder::userIdentifier)).constructor(UserIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentifier").build()}).build();
    private static final SdkField<String> SESSION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionUri").getter(CompleteResourceTokenAuthRequest.getter(CompleteResourceTokenAuthRequest::sessionUri)).setter(CompleteResourceTokenAuthRequest.setter(Builder::sessionUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IDENTIFIER_FIELD, SESSION_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompleteResourceTokenAuthRequest.memberNameToFieldInitializer();
    private final UserIdentifier userIdentifier;
    private final String sessionUri;

    private CompleteResourceTokenAuthRequest(BuilderImpl builder) {
        super(builder);
        this.userIdentifier = builder.userIdentifier;
        this.sessionUri = builder.sessionUri;
    }

    public final UserIdentifier userIdentifier() {
        return this.userIdentifier;
    }

    public final String sessionUri() {
        return this.sessionUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteResourceTokenAuthRequest)) {
            return false;
        }
        CompleteResourceTokenAuthRequest other = (CompleteResourceTokenAuthRequest)((Object)obj);
        return Objects.equals(this.userIdentifier(), other.userIdentifier()) && Objects.equals(this.sessionUri(), other.sessionUri());
    }

    public final String toString() {
        return ToString.builder((String)"CompleteResourceTokenAuthRequest").add("UserIdentifier", (Object)this.userIdentifier()).add("SessionUri", (Object)this.sessionUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userIdentifier": {
                return Optional.ofNullable(clazz.cast(this.userIdentifier()));
            }
            case "sessionUri": {
                return Optional.ofNullable(clazz.cast(this.sessionUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userIdentifier", USER_IDENTIFIER_FIELD);
        map.put("sessionUri", SESSION_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompleteResourceTokenAuthRequest, T> g) {
        return obj -> g.apply((CompleteResourceTokenAuthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private UserIdentifier userIdentifier;
        private String sessionUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteResourceTokenAuthRequest model) {
            super(model);
            this.userIdentifier(model.userIdentifier);
            this.sessionUri(model.sessionUri);
        }

        public final UserIdentifier.Builder getUserIdentifier() {
            return this.userIdentifier != null ? this.userIdentifier.toBuilder() : null;
        }

        public final void setUserIdentifier(UserIdentifier.BuilderImpl userIdentifier) {
            this.userIdentifier = userIdentifier != null ? userIdentifier.build() : null;
        }

        @Override
        public final Builder userIdentifier(UserIdentifier userIdentifier) {
            this.userIdentifier = userIdentifier;
            return this;
        }

        public final String getSessionUri() {
            return this.sessionUri;
        }

        public final void setSessionUri(String sessionUri) {
            this.sessionUri = sessionUri;
        }

        @Override
        public final Builder sessionUri(String sessionUri) {
            this.sessionUri = sessionUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteResourceTokenAuthRequest build() {
            return new CompleteResourceTokenAuthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompleteResourceTokenAuthRequest> {
        public Builder userIdentifier(UserIdentifier var1);

        default public Builder userIdentifier(Consumer<UserIdentifier.Builder> userIdentifier) {
            return this.userIdentifier((UserIdentifier)((UserIdentifier.Builder)UserIdentifier.builder().applyMutation(userIdentifier)).build());
        }

        public Builder sessionUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

