/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreClient;
import software.amazon.awssdk.services.bedrockagentcore.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcore.model.ExtractionJobMetadata;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryExtractionJobsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryExtractionJobsResponse;

public class ListMemoryExtractionJobsIterable
implements SdkIterable<ListMemoryExtractionJobsResponse> {
    private final BedrockAgentCoreClient client;
    private final ListMemoryExtractionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMemoryExtractionJobsIterable(BedrockAgentCoreClient client, ListMemoryExtractionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMemoryExtractionJobsResponseFetcher();
    }

    public Iterator<ListMemoryExtractionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExtractionJobMetadata> jobs() {
        Function<ListMemoryExtractionJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMemoryExtractionJobsResponseFetcher
    implements SyncPageFetcher<ListMemoryExtractionJobsResponse> {
        private ListMemoryExtractionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMemoryExtractionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMemoryExtractionJobsResponse nextPage(ListMemoryExtractionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMemoryExtractionJobsIterable.this.client.listMemoryExtractionJobs(ListMemoryExtractionJobsIterable.this.firstRequest);
            }
            return ListMemoryExtractionJobsIterable.this.client.listMemoryExtractionJobs((ListMemoryExtractionJobsRequest)((Object)ListMemoryExtractionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

