/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StreamUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrowserStreamRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, UpdateBrowserStreamRequest> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserIdentifier").getter(UpdateBrowserStreamRequest.getter(UpdateBrowserStreamRequest::browserIdentifier)).setter(UpdateBrowserStreamRequest.setter(Builder::browserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("browserIdentifier").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateBrowserStreamRequest.getter(UpdateBrowserStreamRequest::sessionId)).setter(UpdateBrowserStreamRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sessionId").build()}).build();
    private static final SdkField<StreamUpdate> STREAM_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamUpdate").getter(UpdateBrowserStreamRequest.getter(UpdateBrowserStreamRequest::streamUpdate)).setter(UpdateBrowserStreamRequest.setter(Builder::streamUpdate)).constructor(StreamUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamUpdate").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateBrowserStreamRequest.getter(UpdateBrowserStreamRequest::clientToken)).setter(UpdateBrowserStreamRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD, SESSION_ID_FIELD, STREAM_UPDATE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBrowserStreamRequest.memberNameToFieldInitializer();
    private final String browserIdentifier;
    private final String sessionId;
    private final StreamUpdate streamUpdate;
    private final String clientToken;

    private UpdateBrowserStreamRequest(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.streamUpdate = builder.streamUpdate;
        this.clientToken = builder.clientToken;
    }

    public final String browserIdentifier() {
        return this.browserIdentifier;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final StreamUpdate streamUpdate() {
        return this.streamUpdate;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrowserStreamRequest)) {
            return false;
        }
        UpdateBrowserStreamRequest other = (UpdateBrowserStreamRequest)((Object)obj);
        return Objects.equals(this.browserIdentifier(), other.browserIdentifier()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.streamUpdate(), other.streamUpdate()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBrowserStreamRequest").add("BrowserIdentifier", (Object)this.browserIdentifier()).add("SessionId", (Object)this.sessionId()).add("StreamUpdate", (Object)this.streamUpdate()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.browserIdentifier()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "streamUpdate": {
                return Optional.ofNullable(clazz.cast(this.streamUpdate()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("streamUpdate", STREAM_UPDATE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrowserStreamRequest, T> g) {
        return obj -> g.apply((UpdateBrowserStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String browserIdentifier;
        private String sessionId;
        private StreamUpdate streamUpdate;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrowserStreamRequest model) {
            super(model);
            this.browserIdentifier(model.browserIdentifier);
            this.sessionId(model.sessionId);
            this.streamUpdate(model.streamUpdate);
            this.clientToken(model.clientToken);
        }

        public final String getBrowserIdentifier() {
            return this.browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final StreamUpdate.Builder getStreamUpdate() {
            return this.streamUpdate != null ? this.streamUpdate.toBuilder() : null;
        }

        public final void setStreamUpdate(StreamUpdate.BuilderImpl streamUpdate) {
            this.streamUpdate = streamUpdate != null ? streamUpdate.build() : null;
        }

        @Override
        public final Builder streamUpdate(StreamUpdate streamUpdate) {
            this.streamUpdate = streamUpdate;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrowserStreamRequest build() {
            return new UpdateBrowserStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrowserStreamRequest> {
        public Builder browserIdentifier(String var1);

        public Builder sessionId(String var1);

        public Builder streamUpdate(StreamUpdate var1);

        default public Builder streamUpdate(Consumer<StreamUpdate.Builder> streamUpdate) {
            return this.streamUpdate((StreamUpdate)((StreamUpdate.Builder)StreamUpdate.builder().applyMutation(streamUpdate)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

