/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemoryRecordOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemoryRecordOutput> {
    private static final SdkField<String> MEMORY_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryRecordId").getter(MemoryRecordOutput.getter(MemoryRecordOutput::memoryRecordId)).setter(MemoryRecordOutput.setter(Builder::memoryRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryRecordId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(MemoryRecordOutput.getter(MemoryRecordOutput::statusAsString)).setter(MemoryRecordOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestIdentifier").getter(MemoryRecordOutput.getter(MemoryRecordOutput::requestIdentifier)).setter(MemoryRecordOutput.setter(Builder::requestIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestIdentifier").build()}).build();
    private static final SdkField<Integer> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("errorCode").getter(MemoryRecordOutput.getter(MemoryRecordOutput::errorCode)).setter(MemoryRecordOutput.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(MemoryRecordOutput.getter(MemoryRecordOutput::errorMessage)).setter(MemoryRecordOutput.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_RECORD_ID_FIELD, STATUS_FIELD, REQUEST_IDENTIFIER_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemoryRecordOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memoryRecordId;
    private final String status;
    private final String requestIdentifier;
    private final Integer errorCode;
    private final String errorMessage;

    private MemoryRecordOutput(BuilderImpl builder) {
        this.memoryRecordId = builder.memoryRecordId;
        this.status = builder.status;
        this.requestIdentifier = builder.requestIdentifier;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final String memoryRecordId() {
        return this.memoryRecordId;
    }

    public final MemoryRecordStatus status() {
        return MemoryRecordStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String requestIdentifier() {
        return this.requestIdentifier;
    }

    public final Integer errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryRecordOutput)) {
            return false;
        }
        MemoryRecordOutput other = (MemoryRecordOutput)obj;
        return Objects.equals(this.memoryRecordId(), other.memoryRecordId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.requestIdentifier(), other.requestIdentifier()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"MemoryRecordOutput").add("MemoryRecordId", (Object)this.memoryRecordId()).add("Status", (Object)this.statusAsString()).add("RequestIdentifier", (Object)this.requestIdentifier()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryRecordId": {
                return Optional.ofNullable(clazz.cast(this.memoryRecordId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "requestIdentifier": {
                return Optional.ofNullable(clazz.cast(this.requestIdentifier()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryRecordId", MEMORY_RECORD_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("requestIdentifier", REQUEST_IDENTIFIER_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryRecordOutput, T> g) {
        return obj -> g.apply((MemoryRecordOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memoryRecordId;
        private String status;
        private String requestIdentifier;
        private Integer errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryRecordOutput model) {
            this.memoryRecordId(model.memoryRecordId);
            this.status(model.status);
            this.requestIdentifier(model.requestIdentifier);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getMemoryRecordId() {
            return this.memoryRecordId;
        }

        public final void setMemoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
        }

        @Override
        public final Builder memoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemoryRecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRequestIdentifier() {
            return this.requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final Integer getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public MemoryRecordOutput build() {
            return new MemoryRecordOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemoryRecordOutput> {
        public Builder memoryRecordId(String var1);

        public Builder status(String var1);

        public Builder status(MemoryRecordStatus var1);

        public Builder requestIdentifier(String var1);

        public Builder errorCode(Integer var1);

        public Builder errorMessage(String var1);
    }
}

