/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.SessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceOauth2TokenResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, GetResourceOauth2TokenResponse> {
    private static final SdkField<String> AUTHORIZATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationUrl").getter(GetResourceOauth2TokenResponse.getter(GetResourceOauth2TokenResponse::authorizationUrl)).setter(GetResourceOauth2TokenResponse.setter(Builder::authorizationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationUrl").build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(GetResourceOauth2TokenResponse.getter(GetResourceOauth2TokenResponse::accessToken)).setter(GetResourceOauth2TokenResponse.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<String> SESSION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionUri").getter(GetResourceOauth2TokenResponse.getter(GetResourceOauth2TokenResponse::sessionUri)).setter(GetResourceOauth2TokenResponse.setter(Builder::sessionUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionUri").build()}).build();
    private static final SdkField<String> SESSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionStatus").getter(GetResourceOauth2TokenResponse.getter(GetResourceOauth2TokenResponse::sessionStatusAsString)).setter(GetResourceOauth2TokenResponse.setter(Builder::sessionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_URL_FIELD, ACCESS_TOKEN_FIELD, SESSION_URI_FIELD, SESSION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceOauth2TokenResponse.memberNameToFieldInitializer();
    private final String authorizationUrl;
    private final String accessToken;
    private final String sessionUri;
    private final String sessionStatus;

    private GetResourceOauth2TokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationUrl = builder.authorizationUrl;
        this.accessToken = builder.accessToken;
        this.sessionUri = builder.sessionUri;
        this.sessionStatus = builder.sessionStatus;
    }

    public final String authorizationUrl() {
        return this.authorizationUrl;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String sessionUri() {
        return this.sessionUri;
    }

    public final SessionStatus sessionStatus() {
        return SessionStatus.fromValue(this.sessionStatus);
    }

    public final String sessionStatusAsString() {
        return this.sessionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceOauth2TokenResponse)) {
            return false;
        }
        GetResourceOauth2TokenResponse other = (GetResourceOauth2TokenResponse)((Object)obj);
        return Objects.equals(this.authorizationUrl(), other.authorizationUrl()) && Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.sessionUri(), other.sessionUri()) && Objects.equals(this.sessionStatusAsString(), other.sessionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceOauth2TokenResponse").add("AuthorizationUrl", (Object)(this.authorizationUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionUri", (Object)this.sessionUri()).add("SessionStatus", (Object)this.sessionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationUrl": {
                return Optional.ofNullable(clazz.cast(this.authorizationUrl()));
            }
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "sessionUri": {
                return Optional.ofNullable(clazz.cast(this.sessionUri()));
            }
            case "sessionStatus": {
                return Optional.ofNullable(clazz.cast(this.sessionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("authorizationUrl", AUTHORIZATION_URL_FIELD);
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("sessionUri", SESSION_URI_FIELD);
        map.put("sessionStatus", SESSION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceOauth2TokenResponse, T> g) {
        return obj -> g.apply((GetResourceOauth2TokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private String authorizationUrl;
        private String accessToken;
        private String sessionUri;
        private String sessionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceOauth2TokenResponse model) {
            super(model);
            this.authorizationUrl(model.authorizationUrl);
            this.accessToken(model.accessToken);
            this.sessionUri(model.sessionUri);
            this.sessionStatus(model.sessionStatus);
        }

        public final String getAuthorizationUrl() {
            return this.authorizationUrl;
        }

        public final void setAuthorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
        }

        @Override
        public final Builder authorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getSessionUri() {
            return this.sessionUri;
        }

        public final void setSessionUri(String sessionUri) {
            this.sessionUri = sessionUri;
        }

        @Override
        public final Builder sessionUri(String sessionUri) {
            this.sessionUri = sessionUri;
            return this;
        }

        public final String getSessionStatus() {
            return this.sessionStatus;
        }

        public final void setSessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
        }

        @Override
        public final Builder sessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
            return this;
        }

        @Override
        public final Builder sessionStatus(SessionStatus sessionStatus) {
            this.sessionStatus(sessionStatus == null ? null : sessionStatus.toString());
            return this;
        }

        @Override
        public GetResourceOauth2TokenResponse build() {
            return new GetResourceOauth2TokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceOauth2TokenResponse> {
        public Builder authorizationUrl(String var1);

        public Builder accessToken(String var1);

        public Builder sessionUri(String var1);

        public Builder sessionStatus(String var1);

        public Builder sessionStatus(SessionStatus var1);
    }
}

