/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordDeleteInput;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordsDeleteInputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteMemoryRecordsRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, BatchDeleteMemoryRecordsRequest> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(BatchDeleteMemoryRecordsRequest.getter(BatchDeleteMemoryRecordsRequest::memoryId)).setter(BatchDeleteMemoryRecordsRequest.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()}).build();
    private static final SdkField<List<MemoryRecordDeleteInput>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("records").getter(BatchDeleteMemoryRecordsRequest.getter(BatchDeleteMemoryRecordsRequest::records)).setter(BatchDeleteMemoryRecordsRequest.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemoryRecordDeleteInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD, RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteMemoryRecordsRequest.memberNameToFieldInitializer();
    private final String memoryId;
    private final List<MemoryRecordDeleteInput> records;

    private BatchDeleteMemoryRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.memoryId = builder.memoryId;
        this.records = builder.records;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<MemoryRecordDeleteInput> records() {
        return this.records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteMemoryRecordsRequest)) {
            return false;
        }
        BatchDeleteMemoryRecordsRequest other = (BatchDeleteMemoryRecordsRequest)((Object)obj);
        return Objects.equals(this.memoryId(), other.memoryId()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteMemoryRecordsRequest").add("MemoryId", (Object)this.memoryId()).add("Records", this.hasRecords() ? this.records() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("records", RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteMemoryRecordsRequest, T> g) {
        return obj -> g.apply((BatchDeleteMemoryRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String memoryId;
        private List<MemoryRecordDeleteInput> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteMemoryRecordsRequest model) {
            super(model);
            this.memoryId(model.memoryId);
            this.records(model.records);
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final List<MemoryRecordDeleteInput.Builder> getRecords() {
            List<MemoryRecordDeleteInput.Builder> result = MemoryRecordsDeleteInputListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<MemoryRecordDeleteInput.BuilderImpl> records) {
            this.records = MemoryRecordsDeleteInputListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<MemoryRecordDeleteInput> records) {
            this.records = MemoryRecordsDeleteInputListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(MemoryRecordDeleteInput ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<MemoryRecordDeleteInput.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (MemoryRecordDeleteInput)((MemoryRecordDeleteInput.Builder)MemoryRecordDeleteInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteMemoryRecordsRequest build() {
            return new BatchDeleteMemoryRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteMemoryRecordsRequest> {
        public Builder memoryId(String var1);

        public Builder records(Collection<MemoryRecordDeleteInput> var1);

        public Builder records(MemoryRecordDeleteInput ... var1);

        public Builder records(Consumer<MemoryRecordDeleteInput.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

