/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ExtractionJob;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMemoryExtractionJobRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, StartMemoryExtractionJobRequest> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(StartMemoryExtractionJobRequest.getter(StartMemoryExtractionJobRequest::memoryId)).setter(StartMemoryExtractionJobRequest.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()}).build();
    private static final SdkField<ExtractionJob> EXTRACTION_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("extractionJob").getter(StartMemoryExtractionJobRequest.getter(StartMemoryExtractionJobRequest::extractionJob)).setter(StartMemoryExtractionJobRequest.setter(Builder::extractionJob)).constructor(ExtractionJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extractionJob").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartMemoryExtractionJobRequest.getter(StartMemoryExtractionJobRequest::clientToken)).setter(StartMemoryExtractionJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD, EXTRACTION_JOB_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMemoryExtractionJobRequest.memberNameToFieldInitializer();
    private final String memoryId;
    private final ExtractionJob extractionJob;
    private final String clientToken;

    private StartMemoryExtractionJobRequest(BuilderImpl builder) {
        super(builder);
        this.memoryId = builder.memoryId;
        this.extractionJob = builder.extractionJob;
        this.clientToken = builder.clientToken;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final ExtractionJob extractionJob() {
        return this.extractionJob;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.extractionJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMemoryExtractionJobRequest)) {
            return false;
        }
        StartMemoryExtractionJobRequest other = (StartMemoryExtractionJobRequest)((Object)obj);
        return Objects.equals(this.memoryId(), other.memoryId()) && Objects.equals(this.extractionJob(), other.extractionJob()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartMemoryExtractionJobRequest").add("MemoryId", (Object)this.memoryId()).add("ExtractionJob", (Object)this.extractionJob()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "extractionJob": {
                return Optional.ofNullable(clazz.cast(this.extractionJob()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("extractionJob", EXTRACTION_JOB_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMemoryExtractionJobRequest, T> g) {
        return obj -> g.apply((StartMemoryExtractionJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String memoryId;
        private ExtractionJob extractionJob;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMemoryExtractionJobRequest model) {
            super(model);
            this.memoryId(model.memoryId);
            this.extractionJob(model.extractionJob);
            this.clientToken(model.clientToken);
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final ExtractionJob.Builder getExtractionJob() {
            return this.extractionJob != null ? this.extractionJob.toBuilder() : null;
        }

        public final void setExtractionJob(ExtractionJob.BuilderImpl extractionJob) {
            this.extractionJob = extractionJob != null ? extractionJob.build() : null;
        }

        @Override
        public final Builder extractionJob(ExtractionJob extractionJob) {
            this.extractionJob = extractionJob;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMemoryExtractionJobRequest build() {
            return new StartMemoryExtractionJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMemoryExtractionJobRequest> {
        public Builder memoryId(String var1);

        public Builder extractionJob(ExtractionJob var1);

        default public Builder extractionJob(Consumer<ExtractionJob.Builder> extractionJob) {
            return this.extractionJob((ExtractionJob)((ExtractionJob.Builder)ExtractionJob.builder().applyMutation(extractionJob)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

