/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.EvaluationResultContent;
import software.amazon.awssdk.services.bedrockagentcore.model.EvaluationResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, EvaluateResponse> {
    private static final SdkField<List<EvaluationResultContent>> EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluationResults").getter(EvaluateResponse.getter(EvaluateResponse::evaluationResults)).setter(EvaluateResponse.setter(Builder::evaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationResultContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluateResponse.memberNameToFieldInitializer();
    private final List<EvaluationResultContent> evaluationResults;

    private EvaluateResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResults = builder.evaluationResults;
    }

    public final boolean hasEvaluationResults() {
        return this.evaluationResults != null && !(this.evaluationResults instanceof SdkAutoConstructList);
    }

    public final List<EvaluationResultContent> evaluationResults() {
        return this.evaluationResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationResults() ? this.evaluationResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateResponse)) {
            return false;
        }
        EvaluateResponse other = (EvaluateResponse)((Object)obj);
        return this.hasEvaluationResults() == other.hasEvaluationResults() && Objects.equals(this.evaluationResults(), other.evaluationResults());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateResponse").add("EvaluationResults", this.hasEvaluationResults() ? this.evaluationResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluationResults": {
                return Optional.ofNullable(clazz.cast(this.evaluationResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<EvaluationResultContent>>> map = new HashMap<String, SdkField<List<EvaluationResultContent>>>();
        map.put("evaluationResults", EVALUATION_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateResponse, T> g) {
        return obj -> g.apply((EvaluateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private List<EvaluationResultContent> evaluationResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateResponse model) {
            super(model);
            this.evaluationResults(model.evaluationResults);
        }

        public final List<EvaluationResultContent.Builder> getEvaluationResults() {
            List<EvaluationResultContent.Builder> result = EvaluationResultsCopier.copyToBuilder(this.evaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationResults(Collection<EvaluationResultContent.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copyFromBuilder(evaluationResults);
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResultContent> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResultContent ... evaluationResults) {
            this.evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(Consumer<EvaluationResultContent.Builder> ... evaluationResults) {
            this.evaluationResults(Stream.of(evaluationResults).map(c -> (EvaluationResultContent)((EvaluationResultContent.Builder)EvaluationResultContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EvaluateResponse build() {
            return new EvaluateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateResponse> {
        public Builder evaluationResults(Collection<EvaluationResultContent> var1);

        public Builder evaluationResults(EvaluationResultContent ... var1);

        public Builder evaluationResults(Consumer<EvaluationResultContent.Builder> ... var1);
    }
}

