/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryMetadataFilterExpression;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryMetadataFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchCriteria> {
    private static final SdkField<String> SEARCH_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchQuery").getter(SearchCriteria.getter(SearchCriteria::searchQuery)).setter(SearchCriteria.setter(Builder::searchQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchQuery").build()}).build();
    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryStrategyId").getter(SearchCriteria.getter(SearchCriteria::memoryStrategyId)).setter(SearchCriteria.setter(Builder::memoryStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()}).build();
    private static final SdkField<Integer> TOPK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("topK").getter(SearchCriteria.getter(SearchCriteria::topK)).setter(SearchCriteria.setter(Builder::topK)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()}).build();
    private static final SdkField<List<MemoryMetadataFilterExpression>> METADATA_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadataFilters").getter(SearchCriteria.getter(SearchCriteria::metadataFilters)).setter(SearchCriteria.setter(Builder::metadataFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemoryMetadataFilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_QUERY_FIELD, MEMORY_STRATEGY_ID_FIELD, TOPK_FIELD, METADATA_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String searchQuery;
    private final String memoryStrategyId;
    private final Integer topK;
    private final List<MemoryMetadataFilterExpression> metadataFilters;

    private SearchCriteria(BuilderImpl builder) {
        this.searchQuery = builder.searchQuery;
        this.memoryStrategyId = builder.memoryStrategyId;
        this.topK = builder.topK;
        this.metadataFilters = builder.metadataFilters;
    }

    public final String searchQuery() {
        return this.searchQuery;
    }

    public final String memoryStrategyId() {
        return this.memoryStrategyId;
    }

    public final Integer topK() {
        return this.topK;
    }

    public final boolean hasMetadataFilters() {
        return this.metadataFilters != null && !(this.metadataFilters instanceof SdkAutoConstructList);
    }

    public final List<MemoryMetadataFilterExpression> metadataFilters() {
        return this.metadataFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topK());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataFilters() ? this.metadataFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)obj;
        return Objects.equals(this.searchQuery(), other.searchQuery()) && Objects.equals(this.memoryStrategyId(), other.memoryStrategyId()) && Objects.equals(this.topK(), other.topK()) && this.hasMetadataFilters() == other.hasMetadataFilters() && Objects.equals(this.metadataFilters(), other.metadataFilters());
    }

    public final String toString() {
        return ToString.builder((String)"SearchCriteria").add("SearchQuery", (Object)(this.searchQuery() == null ? null : "*** Sensitive Data Redacted ***")).add("MemoryStrategyId", (Object)this.memoryStrategyId()).add("TopK", (Object)this.topK()).add("MetadataFilters", this.hasMetadataFilters() ? this.metadataFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "searchQuery": {
                return Optional.ofNullable(clazz.cast(this.searchQuery()));
            }
            case "memoryStrategyId": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategyId()));
            }
            case "topK": {
                return Optional.ofNullable(clazz.cast(this.topK()));
            }
            case "metadataFilters": {
                return Optional.ofNullable(clazz.cast(this.metadataFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("searchQuery", SEARCH_QUERY_FIELD);
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        map.put("topK", TOPK_FIELD);
        map.put("metadataFilters", METADATA_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchCriteria, T> g) {
        return obj -> g.apply((SearchCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String searchQuery;
        private String memoryStrategyId;
        private Integer topK;
        private List<MemoryMetadataFilterExpression> metadataFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCriteria model) {
            this.searchQuery(model.searchQuery);
            this.memoryStrategyId(model.memoryStrategyId);
            this.topK(model.topK);
            this.metadataFilters(model.metadataFilters);
        }

        public final String getSearchQuery() {
            return this.searchQuery;
        }

        public final void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        @Override
        public final Builder searchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public final String getMemoryStrategyId() {
            return this.memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public final Integer getTopK() {
            return this.topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public final List<MemoryMetadataFilterExpression.Builder> getMetadataFilters() {
            List<MemoryMetadataFilterExpression.Builder> result = MemoryMetadataFilterListCopier.copyToBuilder(this.metadataFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataFilters(Collection<MemoryMetadataFilterExpression.BuilderImpl> metadataFilters) {
            this.metadataFilters = MemoryMetadataFilterListCopier.copyFromBuilder(metadataFilters);
        }

        @Override
        public final Builder metadataFilters(Collection<MemoryMetadataFilterExpression> metadataFilters) {
            this.metadataFilters = MemoryMetadataFilterListCopier.copy(metadataFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataFilters(MemoryMetadataFilterExpression ... metadataFilters) {
            this.metadataFilters(Arrays.asList(metadataFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataFilters(Consumer<MemoryMetadataFilterExpression.Builder> ... metadataFilters) {
            this.metadataFilters(Stream.of(metadataFilters).map(c -> (MemoryMetadataFilterExpression)((MemoryMetadataFilterExpression.Builder)MemoryMetadataFilterExpression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SearchCriteria build() {
            return new SearchCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchCriteria> {
        public Builder searchQuery(String var1);

        public Builder memoryStrategyId(String var1);

        public Builder topK(Integer var1);

        public Builder metadataFilters(Collection<MemoryMetadataFilterExpression> var1);

        public Builder metadataFilters(MemoryMetadataFilterExpression ... var1);

        public Builder metadataFilters(Consumer<MemoryMetadataFilterExpression.Builder> ... var1);
    }
}

