/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopRuntimeSessionRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, StopRuntimeSessionRequest> {
    private static final SdkField<String> RUNTIME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeSessionId").getter(StopRuntimeSessionRequest.getter(StopRuntimeSessionRequest::runtimeSessionId)).setter(StopRuntimeSessionRequest.setter(Builder::runtimeSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeArn").getter(StopRuntimeSessionRequest.getter(StopRuntimeSessionRequest::agentRuntimeArn)).setter(StopRuntimeSessionRequest.setter(Builder::agentRuntimeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeArn").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("qualifier").getter(StopRuntimeSessionRequest.getter(StopRuntimeSessionRequest::qualifier)).setter(StopRuntimeSessionRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qualifier").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StopRuntimeSessionRequest.getter(StopRuntimeSessionRequest::clientToken)).setter(StopRuntimeSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_SESSION_ID_FIELD, AGENT_RUNTIME_ARN_FIELD, QUALIFIER_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StopRuntimeSessionRequest.memberNameToFieldInitializer();
    private final String runtimeSessionId;
    private final String agentRuntimeArn;
    private final String qualifier;
    private final String clientToken;

    private StopRuntimeSessionRequest(BuilderImpl builder) {
        super(builder);
        this.runtimeSessionId = builder.runtimeSessionId;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.qualifier = builder.qualifier;
        this.clientToken = builder.clientToken;
    }

    public final String runtimeSessionId() {
        return this.runtimeSessionId;
    }

    public final String agentRuntimeArn() {
        return this.agentRuntimeArn;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopRuntimeSessionRequest)) {
            return false;
        }
        StopRuntimeSessionRequest other = (StopRuntimeSessionRequest)((Object)obj);
        return Objects.equals(this.runtimeSessionId(), other.runtimeSessionId()) && Objects.equals(this.agentRuntimeArn(), other.agentRuntimeArn()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StopRuntimeSessionRequest").add("RuntimeSessionId", (Object)this.runtimeSessionId()).add("AgentRuntimeArn", (Object)this.agentRuntimeArn()).add("Qualifier", (Object)this.qualifier()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runtimeSessionId": {
                return Optional.ofNullable(clazz.cast(this.runtimeSessionId()));
            }
            case "agentRuntimeArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArn()));
            }
            case "qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id", RUNTIME_SESSION_ID_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("qualifier", QUALIFIER_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopRuntimeSessionRequest, T> g) {
        return obj -> g.apply((StopRuntimeSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String runtimeSessionId;
        private String agentRuntimeArn;
        private String qualifier;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StopRuntimeSessionRequest model) {
            super(model);
            this.runtimeSessionId(model.runtimeSessionId);
            this.agentRuntimeArn(model.agentRuntimeArn);
            this.qualifier(model.qualifier);
            this.clientToken(model.clientToken);
        }

        public final String getRuntimeSessionId() {
            return this.runtimeSessionId;
        }

        public final void setRuntimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
        }

        @Override
        public final Builder runtimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopRuntimeSessionRequest build() {
            return new StopRuntimeSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopRuntimeSessionRequest> {
        public Builder runtimeSessionId(String var1);

        public Builder agentRuntimeArn(String var1);

        public Builder qualifier(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

