/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopBrowserSessionRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, StopBrowserSessionRequest> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(StopBrowserSessionRequest.getter(StopBrowserSessionRequest::traceId)).setter(StopBrowserSessionRequest.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Trace-Id").build()}).build();
    private static final SdkField<String> TRACE_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceParent").getter(StopBrowserSessionRequest.getter(StopBrowserSessionRequest::traceParent)).setter(StopBrowserSessionRequest.setter(Builder::traceParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("traceparent").build()}).build();
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserIdentifier").getter(StopBrowserSessionRequest.getter(StopBrowserSessionRequest::browserIdentifier)).setter(StopBrowserSessionRequest.setter(Builder::browserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("browserIdentifier").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(StopBrowserSessionRequest.getter(StopBrowserSessionRequest::sessionId)).setter(StopBrowserSessionRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sessionId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StopBrowserSessionRequest.getter(StopBrowserSessionRequest::clientToken)).setter(StopBrowserSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD, TRACE_PARENT_FIELD, BROWSER_IDENTIFIER_FIELD, SESSION_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StopBrowserSessionRequest.memberNameToFieldInitializer();
    private final String traceId;
    private final String traceParent;
    private final String browserIdentifier;
    private final String sessionId;
    private final String clientToken;

    private StopBrowserSessionRequest(BuilderImpl builder) {
        super(builder);
        this.traceId = builder.traceId;
        this.traceParent = builder.traceParent;
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.clientToken = builder.clientToken;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final String traceParent() {
        return this.traceParent;
    }

    public final String browserIdentifier() {
        return this.browserIdentifier;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopBrowserSessionRequest)) {
            return false;
        }
        StopBrowserSessionRequest other = (StopBrowserSessionRequest)((Object)obj);
        return Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.traceParent(), other.traceParent()) && Objects.equals(this.browserIdentifier(), other.browserIdentifier()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StopBrowserSessionRequest").add("TraceId", (Object)this.traceId()).add("TraceParent", (Object)this.traceParent()).add("BrowserIdentifier", (Object)this.browserIdentifier()).add("SessionId", (Object)this.sessionId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "traceParent": {
                return Optional.ofNullable(clazz.cast(this.traceParent()));
            }
            case "browserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.browserIdentifier()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("X-Amzn-Trace-Id", TRACE_ID_FIELD);
        map.put("traceparent", TRACE_PARENT_FIELD);
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopBrowserSessionRequest, T> g) {
        return obj -> g.apply((StopBrowserSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String traceId;
        private String traceParent;
        private String browserIdentifier;
        private String sessionId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StopBrowserSessionRequest model) {
            super(model);
            this.traceId(model.traceId);
            this.traceParent(model.traceParent);
            this.browserIdentifier(model.browserIdentifier);
            this.sessionId(model.sessionId);
            this.clientToken(model.clientToken);
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getTraceParent() {
            return this.traceParent;
        }

        public final void setTraceParent(String traceParent) {
            this.traceParent = traceParent;
        }

        @Override
        public final Builder traceParent(String traceParent) {
            this.traceParent = traceParent;
            return this;
        }

        public final String getBrowserIdentifier() {
            return this.browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopBrowserSessionRequest build() {
            return new StopBrowserSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopBrowserSessionRequest> {
        public Builder traceId(String var1);

        public Builder traceParent(String var1);

        public Builder browserIdentifier(String var1);

        public Builder sessionId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

