/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.BrowserSessionStatus;
import software.amazon.awssdk.services.bedrockagentcore.model.BrowserSessionStream;
import software.amazon.awssdk.services.bedrockagentcore.model.ViewPort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBrowserSessionResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, GetBrowserSessionResponse> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserIdentifier").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::browserIdentifier)).setter(GetBrowserSessionResponse.setter(Builder::browserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserIdentifier").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::sessionId)).setter(GetBrowserSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::name)).setter(GetBrowserSessionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::createdAt)).setter(GetBrowserSessionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ViewPort> VIEW_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("viewPort").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::viewPort)).setter(GetBrowserSessionResponse.setter(Builder::viewPort)).constructor(ViewPort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewPort").build()}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sessionTimeoutSeconds").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::sessionTimeoutSeconds)).setter(GetBrowserSessionResponse.setter(Builder::sessionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeoutSeconds").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::statusAsString)).setter(GetBrowserSessionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<BrowserSessionStream> STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streams").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::streams)).setter(GetBrowserSessionResponse.setter(Builder::streams)).constructor(BrowserSessionStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build()}).build();
    private static final SdkField<String> SESSION_REPLAY_ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionReplayArtifact").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::sessionReplayArtifact)).setter(GetBrowserSessionResponse.setter(Builder::sessionReplayArtifact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionReplayArtifact").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetBrowserSessionResponse.getter(GetBrowserSessionResponse::lastUpdatedAt)).setter(GetBrowserSessionResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD, SESSION_ID_FIELD, NAME_FIELD, CREATED_AT_FIELD, VIEW_PORT_FIELD, SESSION_TIMEOUT_SECONDS_FIELD, STATUS_FIELD, STREAMS_FIELD, SESSION_REPLAY_ARTIFACT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBrowserSessionResponse.memberNameToFieldInitializer();
    private final String browserIdentifier;
    private final String sessionId;
    private final String name;
    private final Instant createdAt;
    private final ViewPort viewPort;
    private final Integer sessionTimeoutSeconds;
    private final String status;
    private final BrowserSessionStream streams;
    private final String sessionReplayArtifact;
    private final Instant lastUpdatedAt;

    private GetBrowserSessionResponse(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.viewPort = builder.viewPort;
        this.sessionTimeoutSeconds = builder.sessionTimeoutSeconds;
        this.status = builder.status;
        this.streams = builder.streams;
        this.sessionReplayArtifact = builder.sessionReplayArtifact;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String browserIdentifier() {
        return this.browserIdentifier;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ViewPort viewPort() {
        return this.viewPort;
    }

    public final Integer sessionTimeoutSeconds() {
        return this.sessionTimeoutSeconds;
    }

    public final BrowserSessionStatus status() {
        return BrowserSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final BrowserSessionStream streams() {
        return this.streams;
    }

    public final String sessionReplayArtifact() {
        return this.sessionReplayArtifact;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streams());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionReplayArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBrowserSessionResponse)) {
            return false;
        }
        GetBrowserSessionResponse other = (GetBrowserSessionResponse)((Object)obj);
        return Objects.equals(this.browserIdentifier(), other.browserIdentifier()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.viewPort(), other.viewPort()) && Objects.equals(this.sessionTimeoutSeconds(), other.sessionTimeoutSeconds()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.streams(), other.streams()) && Objects.equals(this.sessionReplayArtifact(), other.sessionReplayArtifact()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetBrowserSessionResponse").add("BrowserIdentifier", (Object)this.browserIdentifier()).add("SessionId", (Object)this.sessionId()).add("Name", (Object)this.name()).add("CreatedAt", (Object)this.createdAt()).add("ViewPort", (Object)this.viewPort()).add("SessionTimeoutSeconds", (Object)this.sessionTimeoutSeconds()).add("Status", (Object)this.statusAsString()).add("Streams", (Object)this.streams()).add("SessionReplayArtifact", (Object)this.sessionReplayArtifact()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.browserIdentifier()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "viewPort": {
                return Optional.ofNullable(clazz.cast(this.viewPort()));
            }
            case "sessionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeoutSeconds()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "streams": {
                return Optional.ofNullable(clazz.cast(this.streams()));
            }
            case "sessionReplayArtifact": {
                return Optional.ofNullable(clazz.cast(this.sessionReplayArtifact()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("viewPort", VIEW_PORT_FIELD);
        map.put("sessionTimeoutSeconds", SESSION_TIMEOUT_SECONDS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("streams", STREAMS_FIELD);
        map.put("sessionReplayArtifact", SESSION_REPLAY_ARTIFACT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBrowserSessionResponse, T> g) {
        return obj -> g.apply((GetBrowserSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private String browserIdentifier;
        private String sessionId;
        private String name;
        private Instant createdAt;
        private ViewPort viewPort;
        private Integer sessionTimeoutSeconds;
        private String status;
        private BrowserSessionStream streams;
        private String sessionReplayArtifact;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBrowserSessionResponse model) {
            super(model);
            this.browserIdentifier(model.browserIdentifier);
            this.sessionId(model.sessionId);
            this.name(model.name);
            this.createdAt(model.createdAt);
            this.viewPort(model.viewPort);
            this.sessionTimeoutSeconds(model.sessionTimeoutSeconds);
            this.status(model.status);
            this.streams(model.streams);
            this.sessionReplayArtifact(model.sessionReplayArtifact);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getBrowserIdentifier() {
            return this.browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ViewPort.Builder getViewPort() {
            return this.viewPort != null ? this.viewPort.toBuilder() : null;
        }

        public final void setViewPort(ViewPort.BuilderImpl viewPort) {
            this.viewPort = viewPort != null ? viewPort.build() : null;
        }

        @Override
        public final Builder viewPort(ViewPort viewPort) {
            this.viewPort = viewPort;
            return this;
        }

        public final Integer getSessionTimeoutSeconds() {
            return this.sessionTimeoutSeconds;
        }

        public final void setSessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
        }

        @Override
        public final Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final BrowserSessionStream.Builder getStreams() {
            return this.streams != null ? this.streams.toBuilder() : null;
        }

        public final void setStreams(BrowserSessionStream.BuilderImpl streams) {
            this.streams = streams != null ? streams.build() : null;
        }

        @Override
        public final Builder streams(BrowserSessionStream streams) {
            this.streams = streams;
            return this;
        }

        public final String getSessionReplayArtifact() {
            return this.sessionReplayArtifact;
        }

        public final void setSessionReplayArtifact(String sessionReplayArtifact) {
            this.sessionReplayArtifact = sessionReplayArtifact;
        }

        @Override
        public final Builder sessionReplayArtifact(String sessionReplayArtifact) {
            this.sessionReplayArtifact = sessionReplayArtifact;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetBrowserSessionResponse build() {
            return new GetBrowserSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBrowserSessionResponse> {
        public Builder browserIdentifier(String var1);

        public Builder sessionId(String var1);

        public Builder name(String var1);

        public Builder createdAt(Instant var1);

        public Builder viewPort(ViewPort var1);

        default public Builder viewPort(Consumer<ViewPort.Builder> viewPort) {
            return this.viewPort((ViewPort)((ViewPort.Builder)ViewPort.builder().applyMutation(viewPort)).build());
        }

        public Builder sessionTimeoutSeconds(Integer var1);

        public Builder status(String var1);

        public Builder status(BrowserSessionStatus var1);

        public Builder streams(BrowserSessionStream var1);

        default public Builder streams(Consumer<BrowserSessionStream.Builder> streams) {
            return this.streams((BrowserSessionStream)((BrowserSessionStream.Builder)BrowserSessionStream.builder().applyMutation(streams)).build());
        }

        public Builder sessionReplayArtifact(String var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

