/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcore.model.Branch;
import software.amazon.awssdk.services.bedrockagentcore.model.MetadataMapCopier;
import software.amazon.awssdk.services.bedrockagentcore.model.MetadataValue;
import software.amazon.awssdk.services.bedrockagentcore.model.PayloadType;
import software.amazon.awssdk.services.bedrockagentcore.model.PayloadTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(Event.getter(Event::memoryId)).setter(Event.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryId").build()}).build();
    private static final SdkField<String> ACTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actorId").getter(Event.getter(Event::actorId)).setter(Event.setter(Builder::actorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(Event.getter(Event::sessionId)).setter(Event.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(Event.getter(Event::eventId)).setter(Event.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTimestamp").getter(Event.getter(Event::eventTimestamp)).setter(Event.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()}).build();
    private static final SdkField<List<PayloadType>> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("payload").getter(Event.getter(Event::payload)).setter(Event.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PayloadType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Branch> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("branch").getter(Event.getter(Event::branch)).setter(Event.setter(Builder::branch)).constructor(Branch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()}).build();
    private static final SdkField<Map<String, MetadataValue>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(Event.getter(Event::metadata)).setter(Event.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD, ACTOR_ID_FIELD, SESSION_ID_FIELD, EVENT_ID_FIELD, EVENT_TIMESTAMP_FIELD, PAYLOAD_FIELD, BRANCH_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Event.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memoryId;
    private final String actorId;
    private final String sessionId;
    private final String eventId;
    private final Instant eventTimestamp;
    private final List<PayloadType> payload;
    private final Branch branch;
    private final Map<String, MetadataValue> metadata;

    private Event(BuilderImpl builder) {
        this.memoryId = builder.memoryId;
        this.actorId = builder.actorId;
        this.sessionId = builder.sessionId;
        this.eventId = builder.eventId;
        this.eventTimestamp = builder.eventTimestamp;
        this.payload = builder.payload;
        this.branch = builder.branch;
        this.metadata = builder.metadata;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final String actorId() {
        return this.actorId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final Instant eventTimestamp() {
        return this.eventTimestamp;
    }

    public final boolean hasPayload() {
        return this.payload != null && !(this.payload instanceof SdkAutoConstructList);
    }

    public final List<PayloadType> payload() {
        return this.payload;
    }

    public final Branch branch() {
        return this.branch;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, MetadataValue> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPayload() ? this.payload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.memoryId(), other.memoryId()) && Objects.equals(this.actorId(), other.actorId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && this.hasPayload() == other.hasPayload() && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.branch(), other.branch()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"Event").add("MemoryId", (Object)this.memoryId()).add("ActorId", (Object)this.actorId()).add("SessionId", (Object)this.sessionId()).add("EventId", (Object)this.eventId()).add("EventTimestamp", (Object)this.eventTimestamp()).add("Payload", this.hasPayload() ? this.payload() : null).add("Branch", (Object)this.branch()).add("Metadata", this.hasMetadata() ? this.metadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "actorId": {
                return Optional.ofNullable(clazz.cast(this.actorId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("actorId", ACTOR_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("branch", BRANCH_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memoryId;
        private String actorId;
        private String sessionId;
        private String eventId;
        private Instant eventTimestamp;
        private List<PayloadType> payload = DefaultSdkAutoConstructList.getInstance();
        private Branch branch;
        private Map<String, MetadataValue> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.memoryId(model.memoryId);
            this.actorId(model.actorId);
            this.sessionId(model.sessionId);
            this.eventId(model.eventId);
            this.eventTimestamp(model.eventTimestamp);
            this.payload(model.payload);
            this.branch(model.branch);
            this.metadata(model.metadata);
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getActorId() {
            return this.actorId;
        }

        public final void setActorId(String actorId) {
            this.actorId = actorId;
        }

        @Override
        public final Builder actorId(String actorId) {
            this.actorId = actorId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Instant getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final List<PayloadType.Builder> getPayload() {
            List<PayloadType.Builder> result = PayloadTypeListCopier.copyToBuilder(this.payload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPayload(Collection<PayloadType.BuilderImpl> payload) {
            this.payload = PayloadTypeListCopier.copyFromBuilder(payload);
        }

        @Override
        public final Builder payload(Collection<PayloadType> payload) {
            this.payload = PayloadTypeListCopier.copy(payload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payload(PayloadType ... payload) {
            this.payload(Arrays.asList(payload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payload(Consumer<PayloadType.Builder> ... payload) {
            this.payload(Stream.of(payload).map(c -> (PayloadType)((PayloadType.Builder)PayloadType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Branch.Builder getBranch() {
            return this.branch != null ? this.branch.toBuilder() : null;
        }

        public final void setBranch(Branch.BuilderImpl branch) {
            this.branch = branch != null ? branch.build() : null;
        }

        @Override
        public final Builder branch(Branch branch) {
            this.branch = branch;
            return this;
        }

        public final Map<String, MetadataValue.Builder> getMetadata() {
            Map<String, MetadataValue.Builder> result = MetadataMapCopier.copyToBuilder(this.metadata);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetadata(Map<String, MetadataValue.BuilderImpl> metadata) {
            this.metadata = MetadataMapCopier.copyFromBuilder(metadata);
        }

        @Override
        public final Builder metadata(Map<String, MetadataValue> metadata) {
            this.metadata = MetadataMapCopier.copy(metadata);
            return this;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder memoryId(String var1);

        public Builder actorId(String var1);

        public Builder sessionId(String var1);

        public Builder eventId(String var1);

        public Builder eventTimestamp(Instant var1);

        public Builder payload(Collection<PayloadType> var1);

        public Builder payload(PayloadType ... var1);

        public Builder payload(Consumer<PayloadType.Builder> ... var1);

        public Builder branch(Branch var1);

        default public Builder branch(Consumer<Branch.Builder> branch) {
            return this.branch((Branch)((Branch.Builder)Branch.builder().applyMutation(branch)).build());
        }

        public Builder metadata(Map<String, MetadataValue> var1);
    }
}

