/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeAgentRuntimeResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, InvokeAgentRuntimeResponse> {
    private static final SdkField<String> RUNTIME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeSessionId").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::runtimeSessionId)).setter(InvokeAgentRuntimeResponse.setter(Builder::runtimeSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id").build()}).build();
    private static final SdkField<String> MCP_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mcpSessionId").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::mcpSessionId)).setter(InvokeAgentRuntimeResponse.setter(Builder::mcpSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Mcp-Session-Id").build()}).build();
    private static final SdkField<String> MCP_PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mcpProtocolVersion").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::mcpProtocolVersion)).setter(InvokeAgentRuntimeResponse.setter(Builder::mcpProtocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Mcp-Protocol-Version").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::traceId)).setter(InvokeAgentRuntimeResponse.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Trace-Id").build()}).build();
    private static final SdkField<String> TRACE_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceParent").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::traceParent)).setter(InvokeAgentRuntimeResponse.setter(Builder::traceParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("traceparent").build()}).build();
    private static final SdkField<String> TRACE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceState").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::traceState)).setter(InvokeAgentRuntimeResponse.setter(Builder::traceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("tracestate").build()}).build();
    private static final SdkField<String> BAGGAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baggage").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::baggage)).setter(InvokeAgentRuntimeResponse.setter(Builder::baggage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("baggage").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::contentType)).setter(InvokeAgentRuntimeResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("statusCode").getter(InvokeAgentRuntimeResponse.getter(InvokeAgentRuntimeResponse::statusCode)).setter(InvokeAgentRuntimeResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("statusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_SESSION_ID_FIELD, MCP_SESSION_ID_FIELD, MCP_PROTOCOL_VERSION_FIELD, TRACE_ID_FIELD, TRACE_PARENT_FIELD, TRACE_STATE_FIELD, BAGGAGE_FIELD, CONTENT_TYPE_FIELD, STATUS_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeAgentRuntimeResponse.memberNameToFieldInitializer();
    private final String runtimeSessionId;
    private final String mcpSessionId;
    private final String mcpProtocolVersion;
    private final String traceId;
    private final String traceParent;
    private final String traceState;
    private final String baggage;
    private final String contentType;
    private final Integer statusCodeValue;

    private InvokeAgentRuntimeResponse(BuilderImpl builder) {
        super(builder);
        this.runtimeSessionId = builder.runtimeSessionId;
        this.mcpSessionId = builder.mcpSessionId;
        this.mcpProtocolVersion = builder.mcpProtocolVersion;
        this.traceId = builder.traceId;
        this.traceParent = builder.traceParent;
        this.traceState = builder.traceState;
        this.baggage = builder.baggage;
        this.contentType = builder.contentType;
        this.statusCodeValue = builder.statusCodeValue;
    }

    public final String runtimeSessionId() {
        return this.runtimeSessionId;
    }

    public final String mcpSessionId() {
        return this.mcpSessionId;
    }

    public final String mcpProtocolVersion() {
        return this.mcpProtocolVersion;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final String traceParent() {
        return this.traceParent;
    }

    public final String traceState() {
        return this.traceState;
    }

    public final String baggage() {
        return this.baggage;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final Integer statusCode() {
        return this.statusCodeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcpSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcpProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.baggage());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAgentRuntimeResponse)) {
            return false;
        }
        InvokeAgentRuntimeResponse other = (InvokeAgentRuntimeResponse)((Object)obj);
        return Objects.equals(this.runtimeSessionId(), other.runtimeSessionId()) && Objects.equals(this.mcpSessionId(), other.mcpSessionId()) && Objects.equals(this.mcpProtocolVersion(), other.mcpProtocolVersion()) && Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.traceParent(), other.traceParent()) && Objects.equals(this.traceState(), other.traceState()) && Objects.equals(this.baggage(), other.baggage()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.statusCode(), other.statusCode());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeAgentRuntimeResponse").add("RuntimeSessionId", (Object)this.runtimeSessionId()).add("McpSessionId", (Object)this.mcpSessionId()).add("McpProtocolVersion", (Object)this.mcpProtocolVersion()).add("TraceId", (Object)this.traceId()).add("TraceParent", (Object)this.traceParent()).add("TraceState", (Object)this.traceState()).add("Baggage", (Object)this.baggage()).add("ContentType", (Object)this.contentType()).add("StatusCode", (Object)this.statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runtimeSessionId": {
                return Optional.ofNullable(clazz.cast(this.runtimeSessionId()));
            }
            case "mcpSessionId": {
                return Optional.ofNullable(clazz.cast(this.mcpSessionId()));
            }
            case "mcpProtocolVersion": {
                return Optional.ofNullable(clazz.cast(this.mcpProtocolVersion()));
            }
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "traceParent": {
                return Optional.ofNullable(clazz.cast(this.traceParent()));
            }
            case "traceState": {
                return Optional.ofNullable(clazz.cast(this.traceState()));
            }
            case "baggage": {
                return Optional.ofNullable(clazz.cast(this.baggage()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id", RUNTIME_SESSION_ID_FIELD);
        map.put("Mcp-Session-Id", MCP_SESSION_ID_FIELD);
        map.put("Mcp-Protocol-Version", MCP_PROTOCOL_VERSION_FIELD);
        map.put("X-Amzn-Trace-Id", TRACE_ID_FIELD);
        map.put("traceparent", TRACE_PARENT_FIELD);
        map.put("tracestate", TRACE_STATE_FIELD);
        map.put("baggage", BAGGAGE_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("statusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAgentRuntimeResponse, T> g) {
        return obj -> g.apply((InvokeAgentRuntimeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private String runtimeSessionId;
        private String mcpSessionId;
        private String mcpProtocolVersion;
        private String traceId;
        private String traceParent;
        private String traceState;
        private String baggage;
        private String contentType;
        private Integer statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAgentRuntimeResponse model) {
            super(model);
            this.runtimeSessionId(model.runtimeSessionId);
            this.mcpSessionId(model.mcpSessionId);
            this.mcpProtocolVersion(model.mcpProtocolVersion);
            this.traceId(model.traceId);
            this.traceParent(model.traceParent);
            this.traceState(model.traceState);
            this.baggage(model.baggage);
            this.contentType(model.contentType);
            this.statusCode(model.statusCodeValue);
        }

        public final String getRuntimeSessionId() {
            return this.runtimeSessionId;
        }

        public final void setRuntimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
        }

        @Override
        public final Builder runtimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
            return this;
        }

        public final String getMcpSessionId() {
            return this.mcpSessionId;
        }

        public final void setMcpSessionId(String mcpSessionId) {
            this.mcpSessionId = mcpSessionId;
        }

        @Override
        public final Builder mcpSessionId(String mcpSessionId) {
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public final String getMcpProtocolVersion() {
            return this.mcpProtocolVersion;
        }

        public final void setMcpProtocolVersion(String mcpProtocolVersion) {
            this.mcpProtocolVersion = mcpProtocolVersion;
        }

        @Override
        public final Builder mcpProtocolVersion(String mcpProtocolVersion) {
            this.mcpProtocolVersion = mcpProtocolVersion;
            return this;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getTraceParent() {
            return this.traceParent;
        }

        public final void setTraceParent(String traceParent) {
            this.traceParent = traceParent;
        }

        @Override
        public final Builder traceParent(String traceParent) {
            this.traceParent = traceParent;
            return this;
        }

        public final String getTraceState() {
            return this.traceState;
        }

        public final void setTraceState(String traceState) {
            this.traceState = traceState;
        }

        @Override
        public final Builder traceState(String traceState) {
            this.traceState = traceState;
            return this;
        }

        public final String getBaggage() {
            return this.baggage;
        }

        public final void setBaggage(String baggage) {
            this.baggage = baggage;
        }

        @Override
        public final Builder baggage(String baggage) {
            this.baggage = baggage;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Integer getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public InvokeAgentRuntimeResponse build() {
            return new InvokeAgentRuntimeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeAgentRuntimeResponse> {
        public Builder runtimeSessionId(String var1);

        public Builder mcpSessionId(String var1);

        public Builder mcpProtocolVersion(String var1);

        public Builder traceId(String var1);

        public Builder traceParent(String var1);

        public Builder traceState(String var1);

        public Builder baggage(String var1);

        public Builder contentType(String var1);

        public Builder statusCode(Integer var1);
    }
}

