/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreAsyncClient;
import software.amazon.awssdk.services.bedrockagentcore.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordSummary;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse;

public class RetrieveMemoryRecordsPublisher
implements SdkPublisher<RetrieveMemoryRecordsResponse> {
    private final BedrockAgentCoreAsyncClient client;
    private final RetrieveMemoryRecordsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public RetrieveMemoryRecordsPublisher(BedrockAgentCoreAsyncClient client, RetrieveMemoryRecordsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private RetrieveMemoryRecordsPublisher(BedrockAgentCoreAsyncClient client, RetrieveMemoryRecordsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new RetrieveMemoryRecordsResponseFetcher();
    }

    public void subscribe(Subscriber<? super RetrieveMemoryRecordsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MemoryRecordSummary> memoryRecordSummaries() {
        Function<RetrieveMemoryRecordsResponse, Iterator> getIterator = response -> {
            if (response != null && response.memoryRecordSummaries() != null) {
                return response.memoryRecordSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new RetrieveMemoryRecordsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class RetrieveMemoryRecordsResponseFetcher
    implements AsyncPageFetcher<RetrieveMemoryRecordsResponse> {
        private RetrieveMemoryRecordsResponseFetcher() {
        }

        public boolean hasNextPage(RetrieveMemoryRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<RetrieveMemoryRecordsResponse> nextPage(RetrieveMemoryRecordsResponse previousPage) {
            if (previousPage == null) {
                return RetrieveMemoryRecordsPublisher.this.client.retrieveMemoryRecords(RetrieveMemoryRecordsPublisher.this.firstRequest);
            }
            return RetrieveMemoryRecordsPublisher.this.client.retrieveMemoryRecords((RetrieveMemoryRecordsRequest)((Object)RetrieveMemoryRecordsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

