/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.LeftExpression;
import software.amazon.awssdk.services.bedrockagentcore.model.OperatorType;
import software.amazon.awssdk.services.bedrockagentcore.model.RightExpression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventMetadataFilterExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventMetadataFilterExpression> {
    private static final SdkField<LeftExpression> LEFT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("left").getter(EventMetadataFilterExpression.getter(EventMetadataFilterExpression::left)).setter(EventMetadataFilterExpression.setter(Builder::left)).constructor(LeftExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("left").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(EventMetadataFilterExpression.getter(EventMetadataFilterExpression::operatorAsString)).setter(EventMetadataFilterExpression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final SdkField<RightExpression> RIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("right").getter(EventMetadataFilterExpression.getter(EventMetadataFilterExpression::right)).setter(EventMetadataFilterExpression.setter(Builder::right)).constructor(RightExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("right").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEFT_FIELD, OPERATOR_FIELD, RIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventMetadataFilterExpression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LeftExpression left;
    private final String operator;
    private final RightExpression right;

    private EventMetadataFilterExpression(BuilderImpl builder) {
        this.left = builder.left;
        this.operator = builder.operator;
        this.right = builder.right;
    }

    public final LeftExpression left() {
        return this.left;
    }

    public final OperatorType operator() {
        return OperatorType.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final RightExpression right() {
        return this.right;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.left());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.right());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventMetadataFilterExpression)) {
            return false;
        }
        EventMetadataFilterExpression other = (EventMetadataFilterExpression)obj;
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.right(), other.right());
    }

    public final String toString() {
        return ToString.builder((String)"EventMetadataFilterExpression").add("Left", (Object)this.left()).add("Operator", (Object)this.operatorAsString()).add("Right", (Object)this.right()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "left": {
                return Optional.ofNullable(clazz.cast(this.left()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "right": {
                return Optional.ofNullable(clazz.cast(this.right()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("left", LEFT_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("right", RIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventMetadataFilterExpression, T> g) {
        return obj -> g.apply((EventMetadataFilterExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LeftExpression left;
        private String operator;
        private RightExpression right;

        private BuilderImpl() {
        }

        private BuilderImpl(EventMetadataFilterExpression model) {
            this.left(model.left);
            this.operator(model.operator);
            this.right(model.right);
        }

        public final LeftExpression.Builder getLeft() {
            return this.left != null ? this.left.toBuilder() : null;
        }

        public final void setLeft(LeftExpression.BuilderImpl left) {
            this.left = left != null ? left.build() : null;
        }

        @Override
        public final Builder left(LeftExpression left) {
            this.left = left;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(OperatorType operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final RightExpression.Builder getRight() {
            return this.right != null ? this.right.toBuilder() : null;
        }

        public final void setRight(RightExpression.BuilderImpl right) {
            this.right = right != null ? right.build() : null;
        }

        @Override
        public final Builder right(RightExpression right) {
            this.right = right;
            return this;
        }

        public EventMetadataFilterExpression build() {
            return new EventMetadataFilterExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventMetadataFilterExpression> {
        public Builder left(LeftExpression var1);

        default public Builder left(Consumer<LeftExpression.Builder> left) {
            return this.left((LeftExpression)((LeftExpression.Builder)LeftExpression.builder().applyMutation(left)).build());
        }

        public Builder operator(String var1);

        public Builder operator(OperatorType var1);

        public Builder right(RightExpression var1);

        default public Builder right(Consumer<RightExpression.Builder> right) {
            return this.right((RightExpression)((RightExpression.Builder)RightExpression.builder().applyMutation(right)).build());
        }
    }
}

