/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCodeInterpreterSessionResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, StartCodeInterpreterSessionResponse> {
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeInterpreterIdentifier").getter(StartCodeInterpreterSessionResponse.getter(StartCodeInterpreterSessionResponse::codeInterpreterIdentifier)).setter(StartCodeInterpreterSessionResponse.setter(Builder::codeInterpreterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterIdentifier").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(StartCodeInterpreterSessionResponse.getter(StartCodeInterpreterSessionResponse::sessionId)).setter(StartCodeInterpreterSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StartCodeInterpreterSessionResponse.getter(StartCodeInterpreterSessionResponse::createdAt)).setter(StartCodeInterpreterSessionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_INTERPRETER_IDENTIFIER_FIELD, SESSION_ID_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCodeInterpreterSessionResponse.memberNameToFieldInitializer();
    private final String codeInterpreterIdentifier;
    private final String sessionId;
    private final Instant createdAt;

    private StartCodeInterpreterSessionResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.sessionId = builder.sessionId;
        this.createdAt = builder.createdAt;
    }

    public final String codeInterpreterIdentifier() {
        return this.codeInterpreterIdentifier;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCodeInterpreterSessionResponse)) {
            return false;
        }
        StartCodeInterpreterSessionResponse other = (StartCodeInterpreterSessionResponse)((Object)obj);
        return Objects.equals(this.codeInterpreterIdentifier(), other.codeInterpreterIdentifier()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"StartCodeInterpreterSessionResponse").add("CodeInterpreterIdentifier", (Object)this.codeInterpreterIdentifier()).add("SessionId", (Object)this.sessionId()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeInterpreterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterIdentifier()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCodeInterpreterSessionResponse, T> g) {
        return obj -> g.apply((StartCodeInterpreterSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private String codeInterpreterIdentifier;
        private String sessionId;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCodeInterpreterSessionResponse model) {
            super(model);
            this.codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            this.sessionId(model.sessionId);
            this.createdAt(model.createdAt);
        }

        public final String getCodeInterpreterIdentifier() {
            return this.codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public StartCodeInterpreterSessionResponse build() {
            return new StartCodeInterpreterSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCodeInterpreterSessionResponse> {
        public Builder codeInterpreterIdentifier(String var1);

        public Builder sessionId(String var1);

        public Builder createdAt(Instant var1);
    }
}

