/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.CodeInterpreterSessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCodeInterpreterSessionResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, GetCodeInterpreterSessionResponse> {
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeInterpreterIdentifier").getter(GetCodeInterpreterSessionResponse.getter(GetCodeInterpreterSessionResponse::codeInterpreterIdentifier)).setter(GetCodeInterpreterSessionResponse.setter(Builder::codeInterpreterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterIdentifier").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetCodeInterpreterSessionResponse.getter(GetCodeInterpreterSessionResponse::sessionId)).setter(GetCodeInterpreterSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetCodeInterpreterSessionResponse.getter(GetCodeInterpreterSessionResponse::name)).setter(GetCodeInterpreterSessionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetCodeInterpreterSessionResponse.getter(GetCodeInterpreterSessionResponse::createdAt)).setter(GetCodeInterpreterSessionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sessionTimeoutSeconds").getter(GetCodeInterpreterSessionResponse.getter(GetCodeInterpreterSessionResponse::sessionTimeoutSeconds)).setter(GetCodeInterpreterSessionResponse.setter(Builder::sessionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeoutSeconds").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetCodeInterpreterSessionResponse.getter(GetCodeInterpreterSessionResponse::statusAsString)).setter(GetCodeInterpreterSessionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_INTERPRETER_IDENTIFIER_FIELD, SESSION_ID_FIELD, NAME_FIELD, CREATED_AT_FIELD, SESSION_TIMEOUT_SECONDS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCodeInterpreterSessionResponse.memberNameToFieldInitializer();
    private final String codeInterpreterIdentifier;
    private final String sessionId;
    private final String name;
    private final Instant createdAt;
    private final Integer sessionTimeoutSeconds;
    private final String status;

    private GetCodeInterpreterSessionResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.sessionId = builder.sessionId;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.sessionTimeoutSeconds = builder.sessionTimeoutSeconds;
        this.status = builder.status;
    }

    public final String codeInterpreterIdentifier() {
        return this.codeInterpreterIdentifier;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Integer sessionTimeoutSeconds() {
        return this.sessionTimeoutSeconds;
    }

    public final CodeInterpreterSessionStatus status() {
        return CodeInterpreterSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCodeInterpreterSessionResponse)) {
            return false;
        }
        GetCodeInterpreterSessionResponse other = (GetCodeInterpreterSessionResponse)((Object)obj);
        return Objects.equals(this.codeInterpreterIdentifier(), other.codeInterpreterIdentifier()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.sessionTimeoutSeconds(), other.sessionTimeoutSeconds()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetCodeInterpreterSessionResponse").add("CodeInterpreterIdentifier", (Object)this.codeInterpreterIdentifier()).add("SessionId", (Object)this.sessionId()).add("Name", (Object)this.name()).add("CreatedAt", (Object)this.createdAt()).add("SessionTimeoutSeconds", (Object)this.sessionTimeoutSeconds()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeInterpreterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterIdentifier()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "sessionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeoutSeconds()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("sessionTimeoutSeconds", SESSION_TIMEOUT_SECONDS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCodeInterpreterSessionResponse, T> g) {
        return obj -> g.apply((GetCodeInterpreterSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private String codeInterpreterIdentifier;
        private String sessionId;
        private String name;
        private Instant createdAt;
        private Integer sessionTimeoutSeconds;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCodeInterpreterSessionResponse model) {
            super(model);
            this.codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            this.sessionId(model.sessionId);
            this.name(model.name);
            this.createdAt(model.createdAt);
            this.sessionTimeoutSeconds(model.sessionTimeoutSeconds);
            this.status(model.status);
        }

        public final String getCodeInterpreterIdentifier() {
            return this.codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Integer getSessionTimeoutSeconds() {
            return this.sessionTimeoutSeconds;
        }

        public final void setSessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
        }

        @Override
        public final Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeInterpreterSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetCodeInterpreterSessionResponse build() {
            return new GetCodeInterpreterSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCodeInterpreterSessionResponse> {
        public Builder codeInterpreterIdentifier(String var1);

        public Builder sessionId(String var1);

        public Builder name(String var1);

        public Builder createdAt(Instant var1);

        public Builder sessionTimeoutSeconds(Integer var1);

        public Builder status(String var1);

        public Builder status(CodeInterpreterSessionStatus var1);
    }
}

