/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.BrowserSessionStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrowserStreamResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, UpdateBrowserStreamResponse> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserIdentifier").getter(UpdateBrowserStreamResponse.getter(UpdateBrowserStreamResponse::browserIdentifier)).setter(UpdateBrowserStreamResponse.setter(Builder::browserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserIdentifier").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateBrowserStreamResponse.getter(UpdateBrowserStreamResponse::sessionId)).setter(UpdateBrowserStreamResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<BrowserSessionStream> STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streams").getter(UpdateBrowserStreamResponse.getter(UpdateBrowserStreamResponse::streams)).setter(UpdateBrowserStreamResponse.setter(Builder::streams)).constructor(BrowserSessionStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdateBrowserStreamResponse.getter(UpdateBrowserStreamResponse::updatedAt)).setter(UpdateBrowserStreamResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD, SESSION_ID_FIELD, STREAMS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBrowserStreamResponse.memberNameToFieldInitializer();
    private final String browserIdentifier;
    private final String sessionId;
    private final BrowserSessionStream streams;
    private final Instant updatedAt;

    private UpdateBrowserStreamResponse(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.streams = builder.streams;
        this.updatedAt = builder.updatedAt;
    }

    public final String browserIdentifier() {
        return this.browserIdentifier;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final BrowserSessionStream streams() {
        return this.streams;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streams());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrowserStreamResponse)) {
            return false;
        }
        UpdateBrowserStreamResponse other = (UpdateBrowserStreamResponse)((Object)obj);
        return Objects.equals(this.browserIdentifier(), other.browserIdentifier()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.streams(), other.streams()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBrowserStreamResponse").add("BrowserIdentifier", (Object)this.browserIdentifier()).add("SessionId", (Object)this.sessionId()).add("Streams", (Object)this.streams()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.browserIdentifier()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "streams": {
                return Optional.ofNullable(clazz.cast(this.streams()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("streams", STREAMS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrowserStreamResponse, T> g) {
        return obj -> g.apply((UpdateBrowserStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private String browserIdentifier;
        private String sessionId;
        private BrowserSessionStream streams;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrowserStreamResponse model) {
            super(model);
            this.browserIdentifier(model.browserIdentifier);
            this.sessionId(model.sessionId);
            this.streams(model.streams);
            this.updatedAt(model.updatedAt);
        }

        public final String getBrowserIdentifier() {
            return this.browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final BrowserSessionStream.Builder getStreams() {
            return this.streams != null ? this.streams.toBuilder() : null;
        }

        public final void setStreams(BrowserSessionStream.BuilderImpl streams) {
            this.streams = streams != null ? streams.build() : null;
        }

        @Override
        public final Builder streams(BrowserSessionStream streams) {
            this.streams = streams;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public UpdateBrowserStreamResponse build() {
            return new UpdateBrowserStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrowserStreamResponse> {
        public Builder browserIdentifier(String var1);

        public Builder sessionId(String var1);

        public Builder streams(BrowserSessionStream var1);

        default public Builder streams(Consumer<BrowserSessionStream.Builder> streams) {
            return this.streams((BrowserSessionStream)((BrowserSessionStream.Builder)BrowserSessionStream.builder().applyMutation(streams)).build());
        }

        public Builder updatedAt(Instant var1);
    }
}

