/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the payload content for an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PayloadType implements SdkPojo, Serializable, ToCopyableBuilder<PayloadType.Builder, PayloadType> {
    private static final SdkField<Conversational> CONVERSATIONAL_FIELD = SdkField
            .<Conversational> builder(MarshallingType.SDK_POJO).memberName("conversational")
            .getter(getter(PayloadType::conversational)).setter(setter(Builder::conversational))
            .constructor(Conversational::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversational").build()).build();

    private static final SdkField<Document> BLOB_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT).memberName("blob")
            .getter(getter(PayloadType::blob)).setter(setter(Builder::blob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATIONAL_FIELD,
            BLOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Conversational conversational;

    private final Document blob;

    private final Type type;

    private PayloadType(BuilderImpl builder) {
        this.conversational = builder.conversational;
        this.blob = builder.blob;
        this.type = builder.type;
    }

    /**
     * <p>
     * The conversational content of the payload.
     * </p>
     * 
     * @return The conversational content of the payload.
     */
    public final Conversational conversational() {
        return conversational;
    }

    /**
     * <p>
     * The binary content of the payload.
     * </p>
     * 
     * @return The binary content of the payload.
     */
    public final Document blob() {
        return blob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversational());
        hashCode = 31 * hashCode + Objects.hashCode(blob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayloadType)) {
            return false;
        }
        PayloadType other = (PayloadType) obj;
        return Objects.equals(conversational(), other.conversational()) && Objects.equals(blob(), other.blob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PayloadType").add("Conversational", conversational()).add("Blob", blob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversational":
            return Optional.ofNullable(clazz.cast(conversational()));
        case "blob":
            return Optional.ofNullable(clazz.cast(blob()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #conversational()} initialized to the given value.
     *
     * <p>
     * The conversational content of the payload.
     * </p>
     * 
     * @param conversational
     *        The conversational content of the payload.
     */
    public static PayloadType fromConversational(Conversational conversational) {
        return builder().conversational(conversational).build();
    }

    /**
     * Create an instance of this class with {@link #conversational()} initialized to the given value.
     *
     * <p>
     * The conversational content of the payload.
     * </p>
     * 
     * @param conversational
     *        The conversational content of the payload.
     */
    public static PayloadType fromConversational(Consumer<Conversational.Builder> conversational) {
        Conversational.Builder builder = Conversational.builder();
        conversational.accept(builder);
        return fromConversational(builder.build());
    }

    /**
     * Create an instance of this class with {@link #blob()} initialized to the given value.
     *
     * <p>
     * The binary content of the payload.
     * </p>
     * 
     * @param blob
     *        The binary content of the payload.
     */
    public static PayloadType fromBlob(Document blob) {
        return builder().blob(blob).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversational", CONVERSATIONAL_FIELD);
        map.put("blob", BLOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PayloadType, T> g) {
        return obj -> g.apply((PayloadType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PayloadType> {
        /**
         * <p>
         * The conversational content of the payload.
         * </p>
         * 
         * @param conversational
         *        The conversational content of the payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversational(Conversational conversational);

        /**
         * <p>
         * The conversational content of the payload.
         * </p>
         * This is a convenience method that creates an instance of the {@link Conversational.Builder} avoiding the need
         * to create one manually via {@link Conversational#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Conversational.Builder#build()} is called immediately and its
         * result is passed to {@link #conversational(Conversational)}.
         * 
         * @param conversational
         *        a consumer that will call methods on {@link Conversational.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversational(Conversational)
         */
        default Builder conversational(Consumer<Conversational.Builder> conversational) {
            return conversational(Conversational.builder().applyMutation(conversational).build());
        }

        /**
         * <p>
         * The binary content of the payload.
         * </p>
         * 
         * @param blob
         *        The binary content of the payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blob(Document blob);
    }

    static final class BuilderImpl implements Builder {
        private Conversational conversational;

        private Document blob;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PayloadType model) {
            conversational(model.conversational);
            blob(model.blob);
        }

        public final Conversational.Builder getConversational() {
            return conversational != null ? conversational.toBuilder() : null;
        }

        public final void setConversational(Conversational.BuilderImpl conversational) {
            Object oldValue = this.conversational;
            this.conversational = conversational != null ? conversational.build() : null;
            handleUnionValueChange(Type.CONVERSATIONAL, oldValue, this.conversational);
        }

        @Override
        public final Builder conversational(Conversational conversational) {
            Object oldValue = this.conversational;
            this.conversational = conversational;
            handleUnionValueChange(Type.CONVERSATIONAL, oldValue, this.conversational);
            return this;
        }

        public final Document getBlob() {
            return blob;
        }

        public final void setBlob(Document blob) {
            Object oldValue = this.blob;
            this.blob = blob;
            handleUnionValueChange(Type.BLOB, oldValue, this.blob);
        }

        @Override
        public final Builder blob(Document blob) {
            Object oldValue = this.blob;
            this.blob = blob;
            handleUnionValueChange(Type.BLOB, oldValue, this.blob);
            return this;
        }

        @Override
        public PayloadType build() {
            return new PayloadType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PayloadType#type()
     */
    public enum Type {
        CONVERSATIONAL,

        BLOB,

        UNKNOWN_TO_SDK_VERSION
    }
}
