/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceOauth2TokenRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<GetResourceOauth2TokenRequest.Builder, GetResourceOauth2TokenRequest> {
    private static final SdkField<String> WORKLOAD_IDENTITY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadIdentityToken").getter(getter(GetResourceOauth2TokenRequest::workloadIdentityToken))
            .setter(setter(Builder::workloadIdentityToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityToken").build())
            .build();

    private static final SdkField<String> RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceCredentialProviderName")
            .getter(getter(GetResourceOauth2TokenRequest::resourceCredentialProviderName))
            .setter(setter(Builder::resourceCredentialProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCredentialProviderName")
                    .build()).build();

    private static final SdkField<List<String>> SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("scopes")
            .getter(getter(GetResourceOauth2TokenRequest::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OAUTH2_FLOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("oauth2Flow").getter(getter(GetResourceOauth2TokenRequest::oauth2FlowAsString))
            .setter(setter(Builder::oauth2Flow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2Flow").build()).build();

    private static final SdkField<String> RESOURCE_OAUTH2_RETURN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOauth2ReturnUrl").getter(getter(GetResourceOauth2TokenRequest::resourceOauth2ReturnUrl))
            .setter(setter(Builder::resourceOauth2ReturnUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOauth2ReturnUrl").build())
            .build();

    private static final SdkField<Boolean> FORCE_AUTHENTICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceAuthentication").getter(getter(GetResourceOauth2TokenRequest::forceAuthentication))
            .setter(setter(Builder::forceAuthentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceAuthentication").build())
            .build();

    private static final SdkField<Map<String, String>> CUSTOM_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("customParameters")
            .getter(getter(GetResourceOauth2TokenRequest::customParameters))
            .setter(setter(Builder::customParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_IDENTITY_TOKEN_FIELD,
            RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD, SCOPES_FIELD, OAUTH2_FLOW_FIELD, RESOURCE_OAUTH2_RETURN_URL_FIELD,
            FORCE_AUTHENTICATION_FIELD, CUSTOM_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadIdentityToken;

    private final String resourceCredentialProviderName;

    private final List<String> scopes;

    private final String oauth2Flow;

    private final String resourceOauth2ReturnUrl;

    private final Boolean forceAuthentication;

    private final Map<String, String> customParameters;

    private GetResourceOauth2TokenRequest(BuilderImpl builder) {
        super(builder);
        this.workloadIdentityToken = builder.workloadIdentityToken;
        this.resourceCredentialProviderName = builder.resourceCredentialProviderName;
        this.scopes = builder.scopes;
        this.oauth2Flow = builder.oauth2Flow;
        this.resourceOauth2ReturnUrl = builder.resourceOauth2ReturnUrl;
        this.forceAuthentication = builder.forceAuthentication;
        this.customParameters = builder.customParameters;
    }

    /**
     * <p>
     * The identity token of the workload you want to retrive the Oauth2 Token of.
     * </p>
     * 
     * @return The identity token of the workload you want to retrive the Oauth2 Token of.
     */
    public final String workloadIdentityToken() {
        return workloadIdentityToken;
    }

    /**
     * <p>
     * Reference to the credential provider
     * </p>
     * 
     * @return Reference to the credential provider
     */
    public final String resourceCredentialProviderName() {
        return resourceCredentialProviderName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OAuth scopes requested
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return The OAuth scopes requested
     */
    public final List<String> scopes() {
        return scopes;
    }

    /**
     * <p>
     * The type of flow to be performed
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oauth2Flow} will
     * return {@link Oauth2FlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #oauth2FlowAsString}.
     * </p>
     * 
     * @return The type of flow to be performed
     * @see Oauth2FlowType
     */
    public final Oauth2FlowType oauth2Flow() {
        return Oauth2FlowType.fromValue(oauth2Flow);
    }

    /**
     * <p>
     * The type of flow to be performed
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oauth2Flow} will
     * return {@link Oauth2FlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #oauth2FlowAsString}.
     * </p>
     * 
     * @return The type of flow to be performed
     * @see Oauth2FlowType
     */
    public final String oauth2FlowAsString() {
        return oauth2Flow;
    }

    /**
     * <p>
     * Callback url to redirect after token retrieval completes. Should be one of the provideded urls during
     * WorkloadIdentity creation
     * </p>
     * 
     * @return Callback url to redirect after token retrieval completes. Should be one of the provideded urls during
     *         WorkloadIdentity creation
     */
    public final String resourceOauth2ReturnUrl() {
        return resourceOauth2ReturnUrl;
    }

    /**
     * <p>
     * If true, always initiate a new 3LO flow
     * </p>
     * 
     * @return If true, always initiate a new 3LO flow
     */
    public final Boolean forceAuthentication() {
        return forceAuthentication;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomParameters() {
        return customParameters != null && !(customParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Gives the ability to send extra/custom parameters to the resource credentials provider during the authorization
     * process. Standard OAuth2 flow parameters will not be overriden.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomParameters} method.
     * </p>
     * 
     * @return Gives the ability to send extra/custom parameters to the resource credentials provider during the
     *         authorization process. Standard OAuth2 flow parameters will not be overriden.
     */
    public final Map<String, String> customParameters() {
        return customParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadIdentityToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCredentialProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(oauth2FlowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOauth2ReturnUrl());
        hashCode = 31 * hashCode + Objects.hashCode(forceAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomParameters() ? customParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceOauth2TokenRequest)) {
            return false;
        }
        GetResourceOauth2TokenRequest other = (GetResourceOauth2TokenRequest) obj;
        return Objects.equals(workloadIdentityToken(), other.workloadIdentityToken())
                && Objects.equals(resourceCredentialProviderName(), other.resourceCredentialProviderName())
                && hasScopes() == other.hasScopes() && Objects.equals(scopes(), other.scopes())
                && Objects.equals(oauth2FlowAsString(), other.oauth2FlowAsString())
                && Objects.equals(resourceOauth2ReturnUrl(), other.resourceOauth2ReturnUrl())
                && Objects.equals(forceAuthentication(), other.forceAuthentication())
                && hasCustomParameters() == other.hasCustomParameters()
                && Objects.equals(customParameters(), other.customParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceOauth2TokenRequest")
                .add("WorkloadIdentityToken", workloadIdentityToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceCredentialProviderName", resourceCredentialProviderName())
                .add("Scopes", hasScopes() ? scopes() : null).add("Oauth2Flow", oauth2FlowAsString())
                .add("ResourceOauth2ReturnUrl", resourceOauth2ReturnUrl()).add("ForceAuthentication", forceAuthentication())
                .add("CustomParameters", customParameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workloadIdentityToken":
            return Optional.ofNullable(clazz.cast(workloadIdentityToken()));
        case "resourceCredentialProviderName":
            return Optional.ofNullable(clazz.cast(resourceCredentialProviderName()));
        case "scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        case "oauth2Flow":
            return Optional.ofNullable(clazz.cast(oauth2FlowAsString()));
        case "resourceOauth2ReturnUrl":
            return Optional.ofNullable(clazz.cast(resourceOauth2ReturnUrl()));
        case "forceAuthentication":
            return Optional.ofNullable(clazz.cast(forceAuthentication()));
        case "customParameters":
            return Optional.ofNullable(clazz.cast(customParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workloadIdentityToken", WORKLOAD_IDENTITY_TOKEN_FIELD);
        map.put("resourceCredentialProviderName", RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD);
        map.put("scopes", SCOPES_FIELD);
        map.put("oauth2Flow", OAUTH2_FLOW_FIELD);
        map.put("resourceOauth2ReturnUrl", RESOURCE_OAUTH2_RETURN_URL_FIELD);
        map.put("forceAuthentication", FORCE_AUTHENTICATION_FIELD);
        map.put("customParameters", CUSTOM_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceOauth2TokenRequest, T> g) {
        return obj -> g.apply((GetResourceOauth2TokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceOauth2TokenRequest> {
        /**
         * <p>
         * The identity token of the workload you want to retrive the Oauth2 Token of.
         * </p>
         * 
         * @param workloadIdentityToken
         *        The identity token of the workload you want to retrive the Oauth2 Token of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadIdentityToken(String workloadIdentityToken);

        /**
         * <p>
         * Reference to the credential provider
         * </p>
         * 
         * @param resourceCredentialProviderName
         *        Reference to the credential provider
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCredentialProviderName(String resourceCredentialProviderName);

        /**
         * <p>
         * The OAuth scopes requested
         * </p>
         * 
         * @param scopes
         *        The OAuth scopes requested
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<String> scopes);

        /**
         * <p>
         * The OAuth scopes requested
         * </p>
         * 
         * @param scopes
         *        The OAuth scopes requested
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(String... scopes);

        /**
         * <p>
         * The type of flow to be performed
         * </p>
         * 
         * @param oauth2Flow
         *        The type of flow to be performed
         * @see Oauth2FlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Oauth2FlowType
         */
        Builder oauth2Flow(String oauth2Flow);

        /**
         * <p>
         * The type of flow to be performed
         * </p>
         * 
         * @param oauth2Flow
         *        The type of flow to be performed
         * @see Oauth2FlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Oauth2FlowType
         */
        Builder oauth2Flow(Oauth2FlowType oauth2Flow);

        /**
         * <p>
         * Callback url to redirect after token retrieval completes. Should be one of the provideded urls during
         * WorkloadIdentity creation
         * </p>
         * 
         * @param resourceOauth2ReturnUrl
         *        Callback url to redirect after token retrieval completes. Should be one of the provideded urls during
         *        WorkloadIdentity creation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOauth2ReturnUrl(String resourceOauth2ReturnUrl);

        /**
         * <p>
         * If true, always initiate a new 3LO flow
         * </p>
         * 
         * @param forceAuthentication
         *        If true, always initiate a new 3LO flow
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceAuthentication(Boolean forceAuthentication);

        /**
         * <p>
         * Gives the ability to send extra/custom parameters to the resource credentials provider during the
         * authorization process. Standard OAuth2 flow parameters will not be overriden.
         * </p>
         * 
         * @param customParameters
         *        Gives the ability to send extra/custom parameters to the resource credentials provider during the
         *        authorization process. Standard OAuth2 flow parameters will not be overriden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customParameters(Map<String, String> customParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String workloadIdentityToken;

        private String resourceCredentialProviderName;

        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();

        private String oauth2Flow;

        private String resourceOauth2ReturnUrl;

        private Boolean forceAuthentication;

        private Map<String, String> customParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceOauth2TokenRequest model) {
            super(model);
            workloadIdentityToken(model.workloadIdentityToken);
            resourceCredentialProviderName(model.resourceCredentialProviderName);
            scopes(model.scopes);
            oauth2Flow(model.oauth2Flow);
            resourceOauth2ReturnUrl(model.resourceOauth2ReturnUrl);
            forceAuthentication(model.forceAuthentication);
            customParameters(model.customParameters);
        }

        public final String getWorkloadIdentityToken() {
            return workloadIdentityToken;
        }

        public final void setWorkloadIdentityToken(String workloadIdentityToken) {
            this.workloadIdentityToken = workloadIdentityToken;
        }

        @Override
        public final Builder workloadIdentityToken(String workloadIdentityToken) {
            this.workloadIdentityToken = workloadIdentityToken;
            return this;
        }

        public final String getResourceCredentialProviderName() {
            return resourceCredentialProviderName;
        }

        public final void setResourceCredentialProviderName(String resourceCredentialProviderName) {
            this.resourceCredentialProviderName = resourceCredentialProviderName;
        }

        @Override
        public final Builder resourceCredentialProviderName(String resourceCredentialProviderName) {
            this.resourceCredentialProviderName = resourceCredentialProviderName;
            return this;
        }

        public final Collection<String> getScopes() {
            if (scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return scopes;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = ScopesListTypeCopier.copy(scopes);
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = ScopesListTypeCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        public final String getOauth2Flow() {
            return oauth2Flow;
        }

        public final void setOauth2Flow(String oauth2Flow) {
            this.oauth2Flow = oauth2Flow;
        }

        @Override
        public final Builder oauth2Flow(String oauth2Flow) {
            this.oauth2Flow = oauth2Flow;
            return this;
        }

        @Override
        public final Builder oauth2Flow(Oauth2FlowType oauth2Flow) {
            this.oauth2Flow(oauth2Flow == null ? null : oauth2Flow.toString());
            return this;
        }

        public final String getResourceOauth2ReturnUrl() {
            return resourceOauth2ReturnUrl;
        }

        public final void setResourceOauth2ReturnUrl(String resourceOauth2ReturnUrl) {
            this.resourceOauth2ReturnUrl = resourceOauth2ReturnUrl;
        }

        @Override
        public final Builder resourceOauth2ReturnUrl(String resourceOauth2ReturnUrl) {
            this.resourceOauth2ReturnUrl = resourceOauth2ReturnUrl;
            return this;
        }

        public final Boolean getForceAuthentication() {
            return forceAuthentication;
        }

        public final void setForceAuthentication(Boolean forceAuthentication) {
            this.forceAuthentication = forceAuthentication;
        }

        @Override
        public final Builder forceAuthentication(Boolean forceAuthentication) {
            this.forceAuthentication = forceAuthentication;
            return this;
        }

        public final Map<String, String> getCustomParameters() {
            if (customParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return customParameters;
        }

        public final void setCustomParameters(Map<String, String> customParameters) {
            this.customParameters = CustomRequestParametersTypeCopier.copy(customParameters);
        }

        @Override
        public final Builder customParameters(Map<String, String> customParameters) {
            this.customParameters = CustomRequestParametersTypeCopier.copy(customParameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceOauth2TokenRequest build() {
            return new GetResourceOauth2TokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
