/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A block of content in a response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentBlock implements SdkPojo, Serializable, ToCopyableBuilder<ContentBlock.Builder, ContentBlock> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ContentBlock::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(ContentBlock::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("data").getter(getter(ContentBlock::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mimeType").getter(getter(ContentBlock::mimeType)).setter(setter(Builder::mimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(ContentBlock::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ContentBlock::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ContentBlock::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("size")
            .getter(getter(ContentBlock::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final SdkField<ResourceContent> RESOURCE_FIELD = SdkField.<ResourceContent> builder(MarshallingType.SDK_POJO)
            .memberName("resource").getter(getter(ContentBlock::resource)).setter(setter(Builder::resource))
            .constructor(ResourceContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TEXT_FIELD,
            DATA_FIELD, MIME_TYPE_FIELD, URI_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SIZE_FIELD, RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String text;

    private final SdkBytes data;

    private final String mimeType;

    private final String uri;

    private final String name;

    private final String description;

    private final Long size;

    private final ResourceContent resource;

    private ContentBlock(BuilderImpl builder) {
        this.type = builder.type;
        this.text = builder.text;
        this.data = builder.data;
        this.mimeType = builder.mimeType;
        this.uri = builder.uri;
        this.name = builder.name;
        this.description = builder.description;
        this.size = builder.size;
        this.resource = builder.resource;
    }

    /**
     * <p>
     * The type of content in the block.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContentBlockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of content in the block.
     * @see ContentBlockType
     */
    public final ContentBlockType type() {
        return ContentBlockType.fromValue(type);
    }

    /**
     * <p>
     * The type of content in the block.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContentBlockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of content in the block.
     * @see ContentBlockType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The text content of the block.
     * </p>
     * 
     * @return The text content of the block.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The binary data content of the block.
     * </p>
     * 
     * @return The binary data content of the block.
     */
    public final SdkBytes data() {
        return data;
    }

    /**
     * <p>
     * The MIME type of the content.
     * </p>
     * 
     * @return The MIME type of the content.
     */
    public final String mimeType() {
        return mimeType;
    }

    /**
     * <p>
     * The URI of the content.
     * </p>
     * 
     * @return The URI of the content.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The name of the content block.
     * </p>
     * 
     * @return The name of the content block.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the content block.
     * </p>
     * 
     * @return The description of the content block.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The size of the content in bytes.
     * </p>
     * 
     * @return The size of the content in bytes.
     */
    public final Long size() {
        return size;
    }

    /**
     * <p>
     * The resource associated with the content block.
     * </p>
     * 
     * @return The resource associated with the content block.
     */
    public final ResourceContent resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlock)) {
            return false;
        }
        ContentBlock other = (ContentBlock) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(text(), other.text())
                && Objects.equals(data(), other.data()) && Objects.equals(mimeType(), other.mimeType())
                && Objects.equals(uri(), other.uri()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(size(), other.size())
                && Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentBlock").add("Type", typeAsString()).add("Text", text()).add("Data", data())
                .add("MimeType", mimeType()).add("Uri", uri()).add("Name", name()).add("Description", description())
                .add("Size", size()).add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "mimeType":
            return Optional.ofNullable(clazz.cast(mimeType()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("data", DATA_FIELD);
        map.put("mimeType", MIME_TYPE_FIELD);
        map.put("uri", URI_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBlock, T> g) {
        return obj -> g.apply((ContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentBlock> {
        /**
         * <p>
         * The type of content in the block.
         * </p>
         * 
         * @param type
         *        The type of content in the block.
         * @see ContentBlockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentBlockType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of content in the block.
         * </p>
         * 
         * @param type
         *        The type of content in the block.
         * @see ContentBlockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentBlockType
         */
        Builder type(ContentBlockType type);

        /**
         * <p>
         * The text content of the block.
         * </p>
         * 
         * @param text
         *        The text content of the block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The binary data content of the block.
         * </p>
         * 
         * @param data
         *        The binary data content of the block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);

        /**
         * <p>
         * The MIME type of the content.
         * </p>
         * 
         * @param mimeType
         *        The MIME type of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mimeType(String mimeType);

        /**
         * <p>
         * The URI of the content.
         * </p>
         * 
         * @param uri
         *        The URI of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The name of the content block.
         * </p>
         * 
         * @param name
         *        The name of the content block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the content block.
         * </p>
         * 
         * @param description
         *        The description of the content block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The size of the content in bytes.
         * </p>
         * 
         * @param size
         *        The size of the content in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * <p>
         * The resource associated with the content block.
         * </p>
         * 
         * @param resource
         *        The resource associated with the content block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(ResourceContent resource);

        /**
         * <p>
         * The resource associated with the content block.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceContent.Builder} avoiding the
         * need to create one manually via {@link ResourceContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceContent.Builder#build()} is called immediately and its
         * result is passed to {@link #resource(ResourceContent)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link ResourceContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(ResourceContent)
         */
        default Builder resource(Consumer<ResourceContent.Builder> resource) {
            return resource(ResourceContent.builder().applyMutation(resource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String text;

        private SdkBytes data;

        private String mimeType;

        private String uri;

        private String name;

        private String description;

        private Long size;

        private ResourceContent resource;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlock model) {
            type(model.type);
            text(model.text);
            data(model.data);
            mimeType(model.mimeType);
            uri(model.uri);
            name(model.name);
            description(model.description);
            size(model.size);
            resource(model.resource);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContentBlockType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getMimeType() {
            return mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getSize() {
            return size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final ResourceContent.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(ResourceContent.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(ResourceContent resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public ContentBlock build() {
            return new ContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
