/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that defines the dimensions of a browser viewport in a browser session. The viewport determines the
 * visible area of web content and affects how web pages are rendered and displayed. Proper viewport configuration
 * ensures that web content is displayed correctly for the agent's browsing tasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewPort implements SdkPojo, Serializable, ToCopyableBuilder<ViewPort.Builder, ViewPort> {
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("width")
            .getter(getter(ViewPort::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("height").getter(getter(ViewPort::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIDTH_FIELD, HEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer width;

    private final Integer height;

    private ViewPort(BuilderImpl builder) {
        this.width = builder.width;
        this.height = builder.height;
    }

    /**
     * <p>
     * The width of the viewport in pixels. This value determines the horizontal dimension of the visible area. Valid
     * values range from 800 to 1920 pixels.
     * </p>
     * 
     * @return The width of the viewport in pixels. This value determines the horizontal dimension of the visible area.
     *         Valid values range from 800 to 1920 pixels.
     */
    public final Integer width() {
        return width;
    }

    /**
     * <p>
     * The height of the viewport in pixels. This value determines the vertical dimension of the visible area. Valid
     * values range from 600 to 1080 pixels.
     * </p>
     * 
     * @return The height of the viewport in pixels. This value determines the vertical dimension of the visible area.
     *         Valid values range from 600 to 1080 pixels.
     */
    public final Integer height() {
        return height;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewPort)) {
            return false;
        }
        ViewPort other = (ViewPort) obj;
        return Objects.equals(width(), other.width()) && Objects.equals(height(), other.height());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewPort").add("Width", width()).add("Height", height()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "width":
            return Optional.ofNullable(clazz.cast(width()));
        case "height":
            return Optional.ofNullable(clazz.cast(height()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("width", WIDTH_FIELD);
        map.put("height", HEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewPort, T> g) {
        return obj -> g.apply((ViewPort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewPort> {
        /**
         * <p>
         * The width of the viewport in pixels. This value determines the horizontal dimension of the visible area.
         * Valid values range from 800 to 1920 pixels.
         * </p>
         * 
         * @param width
         *        The width of the viewport in pixels. This value determines the horizontal dimension of the visible
         *        area. Valid values range from 800 to 1920 pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * <p>
         * The height of the viewport in pixels. This value determines the vertical dimension of the visible area. Valid
         * values range from 600 to 1080 pixels.
         * </p>
         * 
         * @param height
         *        The height of the viewport in pixels. This value determines the vertical dimension of the visible
         *        area. Valid values range from 600 to 1080 pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);
    }

    static final class BuilderImpl implements Builder {
        private Integer width;

        private Integer height;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewPort model) {
            width(model.width);
            height(model.height);
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        @Override
        public ViewPort build() {
            return new ViewPort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
