/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceOauth2TokenResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<GetResourceOauth2TokenResponse.Builder, GetResourceOauth2TokenResponse> {
    private static final SdkField<String> AUTHORIZATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationUrl").getter(getter(GetResourceOauth2TokenResponse::authorizationUrl))
            .setter(setter(Builder::authorizationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationUrl").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(GetResourceOauth2TokenResponse::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_URL_FIELD,
            ACCESS_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authorizationUrl;

    private final String accessToken;

    private GetResourceOauth2TokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationUrl = builder.authorizationUrl;
        this.accessToken = builder.accessToken;
    }

    /**
     * <p>
     * The URL for the authorization process, provided if the Access token requires user Authorization.
     * </p>
     * 
     * @return The URL for the authorization process, provided if the Access token requires user Authorization.
     */
    public final String authorizationUrl() {
        return authorizationUrl;
    }

    /**
     * <p>
     * OAuth2 token ready for use
     * </p>
     * 
     * @return OAuth2 token ready for use
     */
    public final String accessToken() {
        return accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceOauth2TokenResponse)) {
            return false;
        }
        GetResourceOauth2TokenResponse other = (GetResourceOauth2TokenResponse) obj;
        return Objects.equals(authorizationUrl(), other.authorizationUrl()) && Objects.equals(accessToken(), other.accessToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceOauth2TokenResponse").add("AuthorizationUrl", authorizationUrl())
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationUrl":
            return Optional.ofNullable(clazz.cast(authorizationUrl()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorizationUrl", AUTHORIZATION_URL_FIELD);
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceOauth2TokenResponse, T> g) {
        return obj -> g.apply((GetResourceOauth2TokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceOauth2TokenResponse> {
        /**
         * <p>
         * The URL for the authorization process, provided if the Access token requires user Authorization.
         * </p>
         * 
         * @param authorizationUrl
         *        The URL for the authorization process, provided if the Access token requires user Authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationUrl(String authorizationUrl);

        /**
         * <p>
         * OAuth2 token ready for use
         * </p>
         * 
         * @param accessToken
         *        OAuth2 token ready for use
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String authorizationUrl;

        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceOauth2TokenResponse model) {
            super(model);
            authorizationUrl(model.authorizationUrl);
            accessToken(model.accessToken);
        }

        public final String getAuthorizationUrl() {
            return authorizationUrl;
        }

        public final void setAuthorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
        }

        @Override
        public final Builder authorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public GetResourceOauth2TokenResponse build() {
            return new GetResourceOauth2TokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
