/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchCriteria> {
    private static final SdkField<String> SEARCH_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchQuery").getter(SearchCriteria.getter(SearchCriteria::searchQuery)).setter(SearchCriteria.setter(Builder::searchQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchQuery").build()}).build();
    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryStrategyId").getter(SearchCriteria.getter(SearchCriteria::memoryStrategyId)).setter(SearchCriteria.setter(Builder::memoryStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()}).build();
    private static final SdkField<Integer> TOPK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("topK").getter(SearchCriteria.getter(SearchCriteria::topK)).setter(SearchCriteria.setter(Builder::topK)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_QUERY_FIELD, MEMORY_STRATEGY_ID_FIELD, TOPK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String searchQuery;
    private final String memoryStrategyId;
    private final Integer topK;

    private SearchCriteria(BuilderImpl builder) {
        this.searchQuery = builder.searchQuery;
        this.memoryStrategyId = builder.memoryStrategyId;
        this.topK = builder.topK;
    }

    public final String searchQuery() {
        return this.searchQuery;
    }

    public final String memoryStrategyId() {
        return this.memoryStrategyId;
    }

    public final Integer topK() {
        return this.topK;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topK());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)obj;
        return Objects.equals(this.searchQuery(), other.searchQuery()) && Objects.equals(this.memoryStrategyId(), other.memoryStrategyId()) && Objects.equals(this.topK(), other.topK());
    }

    public final String toString() {
        return ToString.builder((String)"SearchCriteria").add("SearchQuery", (Object)(this.searchQuery() == null ? null : "*** Sensitive Data Redacted ***")).add("MemoryStrategyId", (Object)this.memoryStrategyId()).add("TopK", (Object)this.topK()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "searchQuery": {
                return Optional.ofNullable(clazz.cast(this.searchQuery()));
            }
            case "memoryStrategyId": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategyId()));
            }
            case "topK": {
                return Optional.ofNullable(clazz.cast(this.topK()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("searchQuery", SEARCH_QUERY_FIELD);
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        map.put("topK", TOPK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchCriteria, T> g) {
        return obj -> g.apply((SearchCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String searchQuery;
        private String memoryStrategyId;
        private Integer topK;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCriteria model) {
            this.searchQuery(model.searchQuery);
            this.memoryStrategyId(model.memoryStrategyId);
            this.topK(model.topK);
        }

        public final String getSearchQuery() {
            return this.searchQuery;
        }

        public final void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        @Override
        public final Builder searchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public final String getMemoryStrategyId() {
            return this.memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public final Integer getTopK() {
            return this.topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public SearchCriteria build() {
            return new SearchCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchCriteria> {
        public Builder searchQuery(String var1);

        public Builder memoryStrategyId(String var1);

        public Builder topK(Integer var1);
    }
}

