/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrowserStreamRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<UpdateBrowserStreamRequest.Builder, UpdateBrowserStreamRequest> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserIdentifier").getter(getter(UpdateBrowserStreamRequest::browserIdentifier))
            .setter(setter(Builder::browserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("browserIdentifier").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(UpdateBrowserStreamRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sessionId").build()).build();

    private static final SdkField<StreamUpdate> STREAM_UPDATE_FIELD = SdkField.<StreamUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("streamUpdate").getter(getter(UpdateBrowserStreamRequest::streamUpdate))
            .setter(setter(Builder::streamUpdate)).constructor(StreamUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamUpdate").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateBrowserStreamRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD,
            SESSION_ID_FIELD, STREAM_UPDATE_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String browserIdentifier;

    private final String sessionId;

    private final StreamUpdate streamUpdate;

    private final String clientToken;

    private UpdateBrowserStreamRequest(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.streamUpdate = builder.streamUpdate;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the browser.
     * </p>
     * 
     * @return The identifier of the browser.
     */
    public final String browserIdentifier() {
        return browserIdentifier;
    }

    /**
     * <p>
     * The identifier of the browser session.
     * </p>
     * 
     * @return The identifier of the browser session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The update to apply to the browser stream.
     * </p>
     * 
     * @return The update to apply to the browser stream.
     */
    public final StreamUpdate streamUpdate() {
        return streamUpdate;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
     *         token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(streamUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrowserStreamRequest)) {
            return false;
        }
        UpdateBrowserStreamRequest other = (UpdateBrowserStreamRequest) obj;
        return Objects.equals(browserIdentifier(), other.browserIdentifier()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(streamUpdate(), other.streamUpdate()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBrowserStreamRequest").add("BrowserIdentifier", browserIdentifier())
                .add("SessionId", sessionId()).add("StreamUpdate", streamUpdate()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserIdentifier":
            return Optional.ofNullable(clazz.cast(browserIdentifier()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "streamUpdate":
            return Optional.ofNullable(clazz.cast(streamUpdate()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("streamUpdate", STREAM_UPDATE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrowserStreamRequest, T> g) {
        return obj -> g.apply((UpdateBrowserStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBrowserStreamRequest> {
        /**
         * <p>
         * The identifier of the browser.
         * </p>
         * 
         * @param browserIdentifier
         *        The identifier of the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserIdentifier(String browserIdentifier);

        /**
         * <p>
         * The identifier of the browser session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the browser session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The update to apply to the browser stream.
         * </p>
         * 
         * @param streamUpdate
         *        The update to apply to the browser stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamUpdate(StreamUpdate streamUpdate);

        /**
         * <p>
         * The update to apply to the browser stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamUpdate.Builder} avoiding the need
         * to create one manually via {@link StreamUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #streamUpdate(StreamUpdate)}.
         * 
         * @param streamUpdate
         *        a consumer that will call methods on {@link StreamUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamUpdate(StreamUpdate)
         */
        default Builder streamUpdate(Consumer<StreamUpdate.Builder> streamUpdate) {
            return streamUpdate(StreamUpdate.builder().applyMutation(streamUpdate).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String browserIdentifier;

        private String sessionId;

        private StreamUpdate streamUpdate;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrowserStreamRequest model) {
            super(model);
            browserIdentifier(model.browserIdentifier);
            sessionId(model.sessionId);
            streamUpdate(model.streamUpdate);
            clientToken(model.clientToken);
        }

        public final String getBrowserIdentifier() {
            return browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final StreamUpdate.Builder getStreamUpdate() {
            return streamUpdate != null ? streamUpdate.toBuilder() : null;
        }

        public final void setStreamUpdate(StreamUpdate.BuilderImpl streamUpdate) {
            this.streamUpdate = streamUpdate != null ? streamUpdate.build() : null;
        }

        @Override
        public final Builder streamUpdate(StreamUpdate streamUpdate) {
            this.streamUpdate = streamUpdate;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrowserStreamRequest build() {
            return new UpdateBrowserStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
