/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains structured content from a tool result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolResultStructuredContent implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolResultStructuredContent.Builder, ToolResultStructuredContent> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(ToolResultStructuredContent::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskStatus").getter(getter(ToolResultStructuredContent::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()).build();

    private static final SdkField<String> STDOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stdout")
            .getter(getter(ToolResultStructuredContent::stdout)).setter(setter(Builder::stdout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stdout").build()).build();

    private static final SdkField<String> STDERR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stderr")
            .getter(getter(ToolResultStructuredContent::stderr)).setter(setter(Builder::stderr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stderr").build()).build();

    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("exitCode").getter(getter(ToolResultStructuredContent::exitCode)).setter(setter(Builder::exitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()).build();

    private static final SdkField<Double> EXECUTION_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("executionTime").getter(getter(ToolResultStructuredContent::executionTime))
            .setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            TASK_STATUS_FIELD, STDOUT_FIELD, STDERR_FIELD, EXIT_CODE_FIELD, EXECUTION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String taskStatus;

    private final String stdout;

    private final String stderr;

    private final Integer exitCode;

    private final Double executionTime;

    private ToolResultStructuredContent(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.stdout = builder.stdout;
        this.stderr = builder.stderr;
        this.exitCode = builder.exitCode;
        this.executionTime = builder.executionTime;
    }

    /**
     * <p>
     * The identifier of the task that produced the result.
     * </p>
     * 
     * @return The identifier of the task that produced the result.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The status of the task that produced the result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The status of the task that produced the result.
     * @see TaskStatus
     */
    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * The status of the task that produced the result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The status of the task that produced the result.
     * @see TaskStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * The standard output from the tool execution.
     * </p>
     * 
     * @return The standard output from the tool execution.
     */
    public final String stdout() {
        return stdout;
    }

    /**
     * <p>
     * The standard error output from the tool execution.
     * </p>
     * 
     * @return The standard error output from the tool execution.
     */
    public final String stderr() {
        return stderr;
    }

    /**
     * <p>
     * The exit code from the tool execution.
     * </p>
     * 
     * @return The exit code from the tool execution.
     */
    public final Integer exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * The execution time of the tool operation in milliseconds.
     * </p>
     * 
     * @return The execution time of the tool operation in milliseconds.
     */
    public final Double executionTime() {
        return executionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stdout());
        hashCode = 31 * hashCode + Objects.hashCode(stderr());
        hashCode = 31 * hashCode + Objects.hashCode(exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolResultStructuredContent)) {
            return false;
        }
        ToolResultStructuredContent other = (ToolResultStructuredContent) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(stdout(), other.stdout()) && Objects.equals(stderr(), other.stderr())
                && Objects.equals(exitCode(), other.exitCode()) && Objects.equals(executionTime(), other.executionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolResultStructuredContent").add("TaskId", taskId()).add("TaskStatus", taskStatusAsString())
                .add("Stdout", stdout()).add("Stderr", stderr()).add("ExitCode", exitCode())
                .add("ExecutionTime", executionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "stdout":
            return Optional.ofNullable(clazz.cast(stdout()));
        case "stderr":
            return Optional.ofNullable(clazz.cast(stderr()));
        case "exitCode":
            return Optional.ofNullable(clazz.cast(exitCode()));
        case "executionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("taskStatus", TASK_STATUS_FIELD);
        map.put("stdout", STDOUT_FIELD);
        map.put("stderr", STDERR_FIELD);
        map.put("exitCode", EXIT_CODE_FIELD);
        map.put("executionTime", EXECUTION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolResultStructuredContent, T> g) {
        return obj -> g.apply((ToolResultStructuredContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolResultStructuredContent> {
        /**
         * <p>
         * The identifier of the task that produced the result.
         * </p>
         * 
         * @param taskId
         *        The identifier of the task that produced the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The status of the task that produced the result.
         * </p>
         * 
         * @param taskStatus
         *        The status of the task that produced the result.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * The status of the task that produced the result.
         * </p>
         * 
         * @param taskStatus
         *        The status of the task that produced the result.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(TaskStatus taskStatus);

        /**
         * <p>
         * The standard output from the tool execution.
         * </p>
         * 
         * @param stdout
         *        The standard output from the tool execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stdout(String stdout);

        /**
         * <p>
         * The standard error output from the tool execution.
         * </p>
         * 
         * @param stderr
         *        The standard error output from the tool execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stderr(String stderr);

        /**
         * <p>
         * The exit code from the tool execution.
         * </p>
         * 
         * @param exitCode
         *        The exit code from the tool execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * The execution time of the tool operation in milliseconds.
         * </p>
         * 
         * @param executionTime
         *        The execution time of the tool operation in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Double executionTime);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String taskStatus;

        private String stdout;

        private String stderr;

        private Integer exitCode;

        private Double executionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolResultStructuredContent model) {
            taskId(model.taskId);
            taskStatus(model.taskStatus);
            stdout(model.stdout);
            stderr(model.stderr);
            exitCode(model.exitCode);
            executionTime(model.executionTime);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getStdout() {
            return stdout;
        }

        public final void setStdout(String stdout) {
            this.stdout = stdout;
        }

        @Override
        public final Builder stdout(String stdout) {
            this.stdout = stdout;
            return this;
        }

        public final String getStderr() {
            return stderr;
        }

        public final void setStderr(String stderr) {
            this.stderr = stderr;
        }

        @Override
        public final Builder stderr(String stderr) {
            this.stderr = stderr;
            return this;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final Double getExecutionTime() {
            return executionTime;
        }

        public final void setExecutionTime(Double executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Double executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        @Override
        public ToolResultStructuredContent build() {
            return new ToolResultStructuredContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
