/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of arguments that specify the operation to perform and its parameters when invoking a tool in Amazon
 * Bedrock. Different tools require different arguments, and this structure provides a flexible way to pass the
 * appropriate arguments to each tool type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolArguments implements SdkPojo, Serializable, ToCopyableBuilder<ToolArguments.Builder, ToolArguments> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(ToolArguments::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(ToolArguments::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<Boolean> CLEAR_CONTEXT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("clearContext").getter(getter(ToolArguments::clearContext)).setter(setter(Builder::clearContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clearContext").build()).build();

    private static final SdkField<String> COMMAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("command")
            .getter(getter(ToolArguments::command)).setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(ToolArguments::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<List<String>> PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("paths")
            .getter(getter(ToolArguments::paths))
            .setter(setter(Builder::paths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InputContentBlock>> CONTENT_FIELD = SdkField
            .<List<InputContentBlock>> builder(MarshallingType.LIST)
            .memberName("content")
            .getter(getter(ToolArguments::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DIRECTORY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directoryPath").getter(getter(ToolArguments::directoryPath)).setter(setter(Builder::directoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryPath").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(ToolArguments::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, LANGUAGE_FIELD,
            CLEAR_CONTEXT_FIELD, COMMAND_FIELD, PATH_FIELD, PATHS_FIELD, CONTENT_FIELD, DIRECTORY_PATH_FIELD, TASK_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String language;

    private final Boolean clearContext;

    private final String command;

    private final String path;

    private final List<String> paths;

    private final List<InputContentBlock> content;

    private final String directoryPath;

    private final String taskId;

    private ToolArguments(BuilderImpl builder) {
        this.code = builder.code;
        this.language = builder.language;
        this.clearContext = builder.clearContext;
        this.command = builder.command;
        this.path = builder.path;
        this.paths = builder.paths;
        this.content = builder.content;
        this.directoryPath = builder.directoryPath;
        this.taskId = builder.taskId;
    }

    /**
     * <p>
     * The code to execute in a code interpreter session. This is the source code in the specified programming language
     * that will be executed by the code interpreter.
     * </p>
     * 
     * @return The code to execute in a code interpreter session. This is the source code in the specified programming
     *         language that will be executed by the code interpreter.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The programming language of the code to execute. This tells the code interpreter which language runtime to use
     * for execution. Common values include 'python', 'javascript', and 'r'.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link ProgrammingLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language of the code to execute. This tells the code interpreter which language runtime
     *         to use for execution. Common values include 'python', 'javascript', and 'r'.
     * @see ProgrammingLanguage
     */
    public final ProgrammingLanguage language() {
        return ProgrammingLanguage.fromValue(language);
    }

    /**
     * <p>
     * The programming language of the code to execute. This tells the code interpreter which language runtime to use
     * for execution. Common values include 'python', 'javascript', and 'r'.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link ProgrammingLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language of the code to execute. This tells the code interpreter which language runtime
     *         to use for execution. Common values include 'python', 'javascript', and 'r'.
     * @see ProgrammingLanguage
     */
    public final String languageAsString() {
        return language;
    }

    /**
     * <p>
     * Whether to clear the context for the tool.
     * </p>
     * 
     * @return Whether to clear the context for the tool.
     */
    public final Boolean clearContext() {
        return clearContext;
    }

    /**
     * <p>
     * The command to execute with the tool.
     * </p>
     * 
     * @return The command to execute with the tool.
     */
    public final String command() {
        return command;
    }

    /**
     * <p>
     * The path for the tool operation.
     * </p>
     * 
     * @return The path for the tool operation.
     */
    public final String path() {
        return path;
    }

    /**
     * For responses, this returns true if the service returned a value for the Paths property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPaths() {
        return paths != null && !(paths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The paths for the tool operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPaths} method.
     * </p>
     * 
     * @return The paths for the tool operation.
     */
    public final List<String> paths() {
        return paths;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The content for the tool operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The content for the tool operation.
     */
    public final List<InputContentBlock> content() {
        return content;
    }

    /**
     * <p>
     * The directory path for the tool operation.
     * </p>
     * 
     * @return The directory path for the tool operation.
     */
    public final String directoryPath() {
        return directoryPath;
    }

    /**
     * <p>
     * The identifier of the task for the tool operation.
     * </p>
     * 
     * @return The identifier of the task for the tool operation.
     */
    public final String taskId() {
        return taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clearContext());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(hasPaths() ? paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(directoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolArguments)) {
            return false;
        }
        ToolArguments other = (ToolArguments) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(languageAsString(), other.languageAsString())
                && Objects.equals(clearContext(), other.clearContext()) && Objects.equals(command(), other.command())
                && Objects.equals(path(), other.path()) && hasPaths() == other.hasPaths()
                && Objects.equals(paths(), other.paths()) && hasContent() == other.hasContent()
                && Objects.equals(content(), other.content()) && Objects.equals(directoryPath(), other.directoryPath())
                && Objects.equals(taskId(), other.taskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolArguments").add("Code", code()).add("Language", languageAsString())
                .add("ClearContext", clearContext()).add("Command", command()).add("Path", path())
                .add("Paths", hasPaths() ? paths() : null).add("Content", hasContent() ? content() : null)
                .add("DirectoryPath", directoryPath()).add("TaskId", taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        case "clearContext":
            return Optional.ofNullable(clazz.cast(clearContext()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "paths":
            return Optional.ofNullable(clazz.cast(paths()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "directoryPath":
            return Optional.ofNullable(clazz.cast(directoryPath()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("clearContext", CLEAR_CONTEXT_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("path", PATH_FIELD);
        map.put("paths", PATHS_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("directoryPath", DIRECTORY_PATH_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolArguments, T> g) {
        return obj -> g.apply((ToolArguments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolArguments> {
        /**
         * <p>
         * The code to execute in a code interpreter session. This is the source code in the specified programming
         * language that will be executed by the code interpreter.
         * </p>
         * 
         * @param code
         *        The code to execute in a code interpreter session. This is the source code in the specified
         *        programming language that will be executed by the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The programming language of the code to execute. This tells the code interpreter which language runtime to
         * use for execution. Common values include 'python', 'javascript', and 'r'.
         * </p>
         * 
         * @param language
         *        The programming language of the code to execute. This tells the code interpreter which language
         *        runtime to use for execution. Common values include 'python', 'javascript', and 'r'.
         * @see ProgrammingLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProgrammingLanguage
         */
        Builder language(String language);

        /**
         * <p>
         * The programming language of the code to execute. This tells the code interpreter which language runtime to
         * use for execution. Common values include 'python', 'javascript', and 'r'.
         * </p>
         * 
         * @param language
         *        The programming language of the code to execute. This tells the code interpreter which language
         *        runtime to use for execution. Common values include 'python', 'javascript', and 'r'.
         * @see ProgrammingLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProgrammingLanguage
         */
        Builder language(ProgrammingLanguage language);

        /**
         * <p>
         * Whether to clear the context for the tool.
         * </p>
         * 
         * @param clearContext
         *        Whether to clear the context for the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clearContext(Boolean clearContext);

        /**
         * <p>
         * The command to execute with the tool.
         * </p>
         * 
         * @param command
         *        The command to execute with the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String command);

        /**
         * <p>
         * The path for the tool operation.
         * </p>
         * 
         * @param path
         *        The path for the tool operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The paths for the tool operation.
         * </p>
         * 
         * @param paths
         *        The paths for the tool operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(Collection<String> paths);

        /**
         * <p>
         * The paths for the tool operation.
         * </p>
         * 
         * @param paths
         *        The paths for the tool operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(String... paths);

        /**
         * <p>
         * The content for the tool operation.
         * </p>
         * 
         * @param content
         *        The content for the tool operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<InputContentBlock> content);

        /**
         * <p>
         * The content for the tool operation.
         * </p>
         * 
         * @param content
         *        The content for the tool operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(InputContentBlock... content);

        /**
         * <p>
         * The content for the tool operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcore.model.InputContentBlock.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcore.model.InputContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcore.model.InputContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #content(List<InputContentBlock>)}.
         * 
         * @param content
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcore.model.InputContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(java.util.Collection<InputContentBlock>)
         */
        Builder content(Consumer<InputContentBlock.Builder>... content);

        /**
         * <p>
         * The directory path for the tool operation.
         * </p>
         * 
         * @param directoryPath
         *        The directory path for the tool operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryPath(String directoryPath);

        /**
         * <p>
         * The identifier of the task for the tool operation.
         * </p>
         * 
         * @param taskId
         *        The identifier of the task for the tool operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String language;

        private Boolean clearContext;

        private String command;

        private String path;

        private List<String> paths = DefaultSdkAutoConstructList.getInstance();

        private List<InputContentBlock> content = DefaultSdkAutoConstructList.getInstance();

        private String directoryPath;

        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolArguments model) {
            code(model.code);
            language(model.language);
            clearContext(model.clearContext);
            command(model.command);
            path(model.path);
            paths(model.paths);
            content(model.content);
            directoryPath(model.directoryPath);
            taskId(model.taskId);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(ProgrammingLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Boolean getClearContext() {
            return clearContext;
        }

        public final void setClearContext(Boolean clearContext) {
            this.clearContext = clearContext;
        }

        @Override
        public final Builder clearContext(Boolean clearContext) {
            this.clearContext = clearContext;
            return this;
        }

        public final String getCommand() {
            return command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Collection<String> getPaths() {
            if (paths instanceof SdkAutoConstructList) {
                return null;
            }
            return paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = StringListCopier.copy(paths);
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = StringListCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String... paths) {
            paths(Arrays.asList(paths));
            return this;
        }

        public final List<InputContentBlock.Builder> getContent() {
            List<InputContentBlock.Builder> result = InputContentBlockListCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<InputContentBlock.BuilderImpl> content) {
            this.content = InputContentBlockListCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<InputContentBlock> content) {
            this.content = InputContentBlockListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(InputContentBlock... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<InputContentBlock.Builder>... content) {
            content(Stream.of(content).map(c -> InputContentBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDirectoryPath() {
            return directoryPath;
        }

        public final void setDirectoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
        }

        @Override
        public final Builder directoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public ToolArguments build() {
            return new ToolArguments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
