/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCodeInterpreterSessionResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<StartCodeInterpreterSessionResponse.Builder, StartCodeInterpreterSessionResponse> {
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterIdentifier")
            .getter(getter(StartCodeInterpreterSessionResponse::codeInterpreterIdentifier))
            .setter(setter(Builder::codeInterpreterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterIdentifier").build())
            .build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(StartCodeInterpreterSessionResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(StartCodeInterpreterSessionResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CODE_INTERPRETER_IDENTIFIER_FIELD, SESSION_ID_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String codeInterpreterIdentifier;

    private final String sessionId;

    private final Instant createdAt;

    private StartCodeInterpreterSessionResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.sessionId = builder.sessionId;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The identifier of the code interpreter.
     * </p>
     * 
     * @return The identifier of the code interpreter.
     */
    public final String codeInterpreterIdentifier() {
        return codeInterpreterIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the created code interpreter session.
     * </p>
     * 
     * @return The unique identifier of the created code interpreter session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The time at which the code interpreter session was created.
     * </p>
     * 
     * @return The time at which the code interpreter session was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCodeInterpreterSessionResponse)) {
            return false;
        }
        StartCodeInterpreterSessionResponse other = (StartCodeInterpreterSessionResponse) obj;
        return Objects.equals(codeInterpreterIdentifier(), other.codeInterpreterIdentifier())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCodeInterpreterSessionResponse")
                .add("CodeInterpreterIdentifier", codeInterpreterIdentifier()).add("SessionId", sessionId())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeInterpreterIdentifier":
            return Optional.ofNullable(clazz.cast(codeInterpreterIdentifier()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCodeInterpreterSessionResponse, T> g) {
        return obj -> g.apply((StartCodeInterpreterSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartCodeInterpreterSessionResponse> {
        /**
         * <p>
         * The identifier of the code interpreter.
         * </p>
         * 
         * @param codeInterpreterIdentifier
         *        The identifier of the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterIdentifier(String codeInterpreterIdentifier);

        /**
         * <p>
         * The unique identifier of the created code interpreter session.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the created code interpreter session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The time at which the code interpreter session was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the code interpreter session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String codeInterpreterIdentifier;

        private String sessionId;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCodeInterpreterSessionResponse model) {
            super(model);
            codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            sessionId(model.sessionId);
            createdAt(model.createdAt);
        }

        public final String getCodeInterpreterIdentifier() {
            return codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public StartCodeInterpreterSessionResponse build() {
            return new StartCodeInterpreterSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
